/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EffectHarvest
extends AbstractEffect {
    public EffectHarvest() {
        super("harvest", "Harvest");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult ray = (BlockRayTraceResult)rayTraceResult;
            if (world.field_72995_K) {
                return;
            }
            for (BlockPos blockpos : SpellUtil.calcAOEBlocks(shooter, ray.func_216350_a(), ray, EffectHarvest.getBuffCount(augments, AugmentAOE.class))) {
                CropsBlock cropsBlock;
                BlockState state = world.func_180495_p(blockpos);
                if (this.isTree(state)) {
                    Set<BlockPos> list = this.getTree(world, ray.func_216350_a().func_177958_n(), ray.func_216350_a().func_177956_o(), ray.func_216350_a().func_177952_p(), true, new HashSet<BlockPos>());
                    list.forEach(listPos -> {
                        if (!BlockUtil.destroyRespectsClaim(shooter, world, listPos)) {
                            return;
                        }
                        if (this.hasBuff(augments, AugmentExtract.class)) {
                            world.func_180495_p(listPos).func_215693_a(LootUtil.getSilkContext((ServerWorld)world, listPos, shooter)).forEach(i -> world.func_217376_c((Entity)new ItemEntity(world, (double)listPos.func_177958_n(), (double)listPos.func_177956_o(), (double)listPos.func_177952_p(), i)));
                            BlockUtil.destroyBlockSafelyWithoutSound(world, listPos, false);
                        } else if (this.hasBuff(augments, AugmentFortune.class)) {
                            world.func_180495_p(listPos).func_215693_a(LootUtil.getFortuneContext((ServerWorld)world, listPos, shooter, EffectHarvest.getBuffCount(augments, AugmentFortune.class))).forEach(i -> world.func_217376_c((Entity)new ItemEntity(world, (double)listPos.func_177958_n(), (double)listPos.func_177956_o(), (double)listPos.func_177952_p(), i)));
                            BlockUtil.destroyBlockSafelyWithoutSound(world, listPos, false);
                        } else {
                            BlockUtil.destroyBlockSafelyWithoutSound(world, listPos, true);
                        }
                    });
                    world.func_217379_c(2001, blockpos, Block.func_196246_j((BlockState)state));
                    return;
                }
                if (state.func_177230_c() instanceof FarmlandBlock || world.func_180495_p(blockpos.func_177984_a()).func_177230_c() instanceof CropsBlock) {
                    blockpos = blockpos.func_177984_a();
                    state = world.func_180495_p(blockpos);
                }
                if (!(state.func_177230_c() instanceof CropsBlock) || !(cropsBlock = (CropsBlock)world.func_180495_p(blockpos).func_177230_c()).func_185525_y(state) || !(world instanceof ServerWorld)) continue;
                List cropDrops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)blockpos, (TileEntity)world.func_175625_s(blockpos));
                if (this.hasBuff(augments, AugmentFortune.class)) {
                    cropDrops = state.func_215693_a(LootUtil.getFortuneContext((ServerWorld)world, blockpos, shooter, EffectHarvest.getBuffCount(augments, AugmentFortune.class)));
                }
                BlockPos finalBlockpos = blockpos;
                cropDrops.forEach(d -> {
                    if (d.func_77973_b() == BlockRegistry.MANA_BLOOM_CROP.func_199767_j()) {
                        return;
                    }
                    world.func_217376_c((Entity)new ItemEntity(world, (double)finalBlockpos.func_177958_n(), (double)finalBlockpos.func_177956_o(), (double)finalBlockpos.func_177952_p(), d));
                });
                world.func_175656_a(blockpos, cropsBlock.func_185528_e(1));
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
        BlockState state = world.func_180495_p(pos);
        if (this.isTree(state)) {
            return true;
        }
        if (state.func_177230_c() instanceof FarmlandBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof CropsBlock) {
            pos = pos.func_177984_a();
            state = world.func_180495_p(pos);
        }
        if (!(state.func_177230_c() instanceof CropsBlock)) {
            return false;
        }
        CropsBlock cropsBlock = (CropsBlock)world.func_180495_p(pos).func_177230_c();
        return cropsBlock.func_185525_y(state) && world instanceof ServerWorld;
    }

    public boolean isTree(BlockState blockstate) {
        return blockstate.func_177230_c() instanceof LogBlock || blockstate.func_177230_c() instanceof LeavesBlock;
    }

    public Set<BlockPos> getTree(World world, int x, int y, int z, boolean fromTree, Set<BlockPos> blocks) {
        if (blocks.size() > 500) {
            return blocks;
        }
        BlockPos pos = new BlockPos(x, y, z);
        boolean isTree = this.isTree(world.func_180495_p(pos));
        if (isTree && !blocks.contains(pos)) {
            blocks.add(pos);
        } else if (fromTree) {
            return blocks;
        }
        this.getTree(world, pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p(), isTree, blocks);
        this.getTree(world, pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p(), isTree, blocks);
        this.getTree(world, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), isTree, blocks);
        this.getTree(world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p(), isTree, blocks);
        this.getTree(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1, isTree, blocks);
        this.getTree(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1, isTree, blocks);
        return blocks;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151056_x;
    }

    @Override
    public int getManaCost() {
        return 30;
    }

    @Override
    protected String getBookDescription() {
        return "Harvests grown crops and trees. When used on grown crops, this spell will obtain the fully grown product without destroying the plant.";
    }
}

