/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EffectHeal
extends AbstractEffect {
    public EffectHeal() {
        super("heal", "Heal");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (entity.field_70128_L || entity.func_110143_aJ() <= 0.0f) {
                return;
            }
            float maxHealth = entity.func_110138_aP();
            float healVal = 3.0f + (float)(3 * EffectHeal.getBuffCount(augments, AugmentAmplify.class));
            if (entity.func_110143_aJ() + healVal > maxHealth) {
                entity.func_70606_j(entity.func_110138_aP());
            } else {
                entity.func_70606_j(entity.func_110143_aJ() + healVal);
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.livingEntityHitSuccess(rayTraceResult);
    }

    @Override
    public int getManaCost() {
        return 40;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151060_bw;
    }

    @Override
    protected String getBookDescription() {
        return "Heals a small amount of health for the target";
    }
}

