/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class EffectPickup
extends AbstractEffect {
    public EffectPickup() {
        super("pickup", "Item Pickup");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        BlockPos pos = new BlockPos(rayTraceResult.func_216347_e());
        int expansion = EffectPickup.getBuffCount(augments, AugmentAOE.class);
        List entityList = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(pos.func_177965_g(3 + expansion).func_177964_d(3 + expansion).func_177981_b(3 + expansion), pos.func_177985_f(3 + expansion).func_177970_e(3 + expansion).func_177979_c(3 + expansion)));
        for (ItemEntity i : entityList) {
            if (shooter != null) {
                i.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_());
            }
            if (shooter instanceof PlayerEntity && !(shooter instanceof FakePlayer)) {
                i.func_70100_b_((PlayerEntity)shooter);
                continue;
            }
            if (shooter instanceof IPickupResponder) {
                i.func_92058_a(((IPickupResponder)shooter).onPickup(i.func_92059_d()));
                continue;
            }
            if (!(spellContext.castingTile instanceof IPickupResponder)) continue;
            i.func_92058_a(((IPickupResponder)spellContext.castingTile).onPickup(i.func_92059_d()));
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        BlockPos pos = new BlockPos(rayTraceResult.func_216347_e());
        int expansion = EffectPickup.getBuffCount(augments, AugmentAOE.class);
        return true;
    }

    @Override
    protected String getBookDescription() {
        return "Picks up nearby items in a medium radius where this spell is activated. The range may be expanded with AOE.";
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221862_eo;
    }

    @Override
    public int getManaCost() {
        return 10;
    }
}

