/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPlaceBlockResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class EffectPlaceBlock
extends AbstractEffect {
    public EffectPlaceBlock() {
        super("place_block", "Place Block");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult result = (BlockRayTraceResult)rayTraceResult;
            BlockPos hitPos = result.func_216350_a().func_177972_a(result.func_216354_b());
            if (spellContext.castingTile instanceof IPlaceBlockResponder) {
                ItemStack stack = ((IPlaceBlockResponder)spellContext.castingTile).onPlaceBlock();
                if (stack == null || !(stack.func_77973_b() instanceof BlockItem)) {
                    return;
                }
                BlockItem item = (BlockItem)stack.func_77973_b();
                this.attemptPlace(world, stack, item, result);
            } else if (shooter instanceof IPlaceBlockResponder) {
                ItemStack stack = ((IPlaceBlockResponder)shooter).onPlaceBlock();
                if (stack == null || !(stack.func_77973_b() instanceof BlockItem)) {
                    return;
                }
                BlockItem item = (BlockItem)stack.func_77973_b();
                if (world.func_180495_p(hitPos).func_185904_a() != Material.field_151579_a) {
                    result = new BlockRayTraceResult(result.func_216347_e().func_72441_c(0.0, 1.0, 0.0), Direction.UP, result.func_216350_a(), false);
                }
                this.attemptPlace(world, stack, item, result);
            } else if (shooter instanceof PlayerEntity) {
                BlockItem item;
                ItemStack stack;
                PlayerEntity playerEntity = (PlayerEntity)shooter;
                NonNullList list = playerEntity.field_71071_by.field_70462_a;
                for (int i = 0; !(i >= 9 || (stack = (ItemStack)list.get(i)).func_77973_b() instanceof BlockItem && world instanceof ServerWorld && ActionResultType.SUCCESS == this.attemptPlace(world, stack, item = (BlockItem)stack.func_77973_b(), result)); ++i) {
                }
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return this.nonAirBlockSuccess(rayTraceResult, world);
    }

    public ActionResultType attemptPlace(World world, ItemStack stack, BlockItem item, BlockRayTraceResult result) {
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        BlockItemUseContext context = BlockItemUseContext.func_221536_a((BlockItemUseContext)new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, result)), (BlockPos)result.func_216350_a(), (Direction)result.func_216354_b());
        return item.func_195942_a(context);
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221656_ap;
    }

    @Override
    protected String getBookDescription() {
        return "Places blocks from the casters inventory. If a player is casting this, this spell will place blocks from the hot bar first.";
    }
}

