/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.RedstoneAir;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EffectRedstone
extends AbstractEffect {
    public EffectRedstone() {
        super("redstone_signal", "Redstone Signal");
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockRayTraceResult) {
            BlockState state = BlockRegistry.REDSTONE_AIR.func_176223_P();
            int signalModifier = this.getAmplificationBonus(augments) + 10;
            if (signalModifier < 1) {
                signalModifier = 1;
            }
            if (signalModifier > 15) {
                signalModifier = 15;
            }
            state = (BlockState)state.func_206870_a((IProperty)RedstoneAir.POWER, (Comparable)Integer.valueOf(signalModifier));
            BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a().func_177972_a(((BlockRayTraceResult)rayTraceResult).func_216354_b());
            if (world.func_180495_p(pos).func_185904_a() != Material.field_151579_a || world.func_180495_p(pos).func_177230_c() == BlockRegistry.REDSTONE_AIR) {
                return;
            }
            int timeBonus = EffectRedstone.getBuffCount(augments, AugmentExtendTime.class);
            world.func_175656_a(pos, state);
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 5 + timeBonus * 10);
            BlockPos hitPos = pos.func_177972_a(((BlockRayTraceResult)rayTraceResult).func_216354_b().func_176734_d());
            BlockUtil.safelyUpdateState(world, pos);
            world.func_195593_d(pos, state.func_177230_c());
            world.func_195593_d(hitPos, state.func_177230_c());
        }
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221858_em;
    }

    @Override
    protected String getBookDescription() {
        return "Creates a brief redstone signal on a block, like a button. The signal starts at strength 10, and may be increased with Amplify, or decreased with Dampen. The duration may be extended with Extend Time.";
    }

    @Override
    public int getManaCost() {
        return 0;
    }
}

