/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EffectSmelt
extends AbstractEffect {
    public EffectSmelt() {
        super("smelt", "Smelt");
    }

    public float getHardness(List<AbstractAugment> augments) {
        float maxHardness = 5.0f + (float)(25 * this.getAmplificationBonus(augments));
        int buff = this.getAmplificationBonus(augments);
        if (buff == -1) {
            maxHardness = 2.5f;
        } else if (buff == -2) {
            maxHardness = 1.0f;
        } else if (buff < -2) {
            maxHardness = 0.5f;
        }
        return maxHardness;
    }

    @Override
    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments, SpellContext spellContext) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return;
        }
        float maxHardness = this.getHardness(augments);
        int aoeBuff = EffectSmelt.getBuffCount(augments, AugmentAOE.class);
        int maxItemSmelt = 3 + 8 * aoeBuff;
        ImmutableList<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), (BlockRayTraceResult)rayTraceResult, 1 + aoeBuff, 1 + aoeBuff, 1, -1);
        List itemEntities = world.func_217357_a(ItemEntity.class, new AxisAlignedBB(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_186662_g((double)aoeBuff + 1.0));
        this.smeltItems(world, itemEntities, maxItemSmelt);
        for (BlockPos pos : posList) {
            this.smeltBlock(world, pos, maxHardness, shooter);
        }
    }

    public void smeltBlock(World world, BlockPos pos, float maxHardness, LivingEntity shooter) {
        ItemStack itemstack;
        BlockState state = world.func_180495_p(pos);
        Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1)}), world);
        if (optional.isPresent() && !(itemstack = ((FurnaceRecipe)optional.get()).func_77571_b()).func_190926_b()) {
            if (itemstack.func_77973_b() instanceof BlockItem) {
                world.func_175656_a(pos, ((BlockItem)itemstack.func_77973_b()).func_179223_d().func_176223_P());
            } else {
                if (!(state.func_185887_b((IBlockReader)world, pos) <= maxHardness) || !(state.func_185887_b((IBlockReader)world, pos) >= 0.0f)) {
                    return;
                }
                BlockUtil.destroyBlockSafely(world, pos, false, shooter);
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack.func_77946_l()));
                BlockUtil.safelyUpdateState(world, pos);
            }
        }
    }

    public void smeltItems(World world, List<ItemEntity> itemEntities, int maxItemSmelt) {
        int numSmelted = 0;
        for (int i = 0; i < itemEntities.size() && numSmelted <= maxItemSmelt; ++i) {
            ItemStack result;
            ItemEntity entity = itemEntities.get(i);
            Optional optional = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{entity.func_92059_d()}), world);
            if (!optional.isPresent() || (result = ((FurnaceRecipe)optional.get()).func_77571_b().func_77946_l()).func_190926_b()) continue;
            while (numSmelted < maxItemSmelt && !entity.func_92059_d().func_190926_b()) {
                entity.func_92059_d().func_190918_g(1);
                world.func_217376_c((Entity)new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), result.func_77946_l()));
                ++numSmelted;
            }
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return rayTraceResult instanceof BlockRayTraceResult;
    }

    @Override
    protected String getBookDescription() {
        return "Smelts blocks and items in the world. AOE will increase the number of items and radius of blocks that can be smelted at once, while Amplify will allow Smelt to work on blocks of higher hardness.";
    }

    @Override
    public int getManaCost() {
        return 40;
    }

    @Override
    public Item getCraftingReagent() {
        return Items.field_222102_pI;
    }
}

