/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.method;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class MethodProjectile
extends AbstractCastMethod {
    public MethodProjectile() {
        super("projectile", "Projectile");
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    public void summonProjectiles(World world, LivingEntity shooter, List<AbstractAugment> augments) {
        ArrayList<EntityProjectileSpell> projectiles = new ArrayList<EntityProjectileSpell>();
        int numPierce = MethodProjectile.getBuffCount(augments, AugmentPierce.class);
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(world, shooter, this.resolver, numPierce);
        projectiles.add(projectileSpell);
        int numSplits = MethodProjectile.getBuffCount(augments, AugmentSplit.class);
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.func_174811_aO().func_176746_e();
            if (i % 2 == 0) {
                offset = offset.func_176734_d();
            }
            BlockPos projPos = shooter.func_180425_c().func_177967_a(offset, i);
            projPos = projPos.func_177963_a(0.0, 1.5, 0.0);
            EntityProjectileSpell spell = new EntityProjectileSpell(world, shooter, this.resolver, numPierce);
            spell.func_70107_b(projPos.func_177958_n(), projPos.func_177956_o(), projPos.func_177952_p());
            projectiles.add(spell);
        }
        float velocity = 1.0f + (float)MethodProjectile.getBuffCount(augments, AugmentAccelerate.class);
        for (EntityProjectileSpell proj : projectiles) {
            proj.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, velocity, 0.8f);
            world.func_217376_c((Entity)proj);
        }
    }

    public void summonProjectiles(World world, BlockPos pos, LivingEntity shooter, List<AbstractAugment> augments) {
        ArrayList<EntityProjectileSpell> projectiles = new ArrayList<EntityProjectileSpell>();
        int numPierce = MethodProjectile.getBuffCount(augments, AugmentPierce.class);
        EntityProjectileSpell projectileSpell = new EntityProjectileSpell(world, shooter, this.resolver, numPierce);
        projectileSpell.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        projectiles.add(projectileSpell);
        int numSplits = MethodProjectile.getBuffCount(augments, AugmentSplit.class);
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.func_174811_aO().func_176746_e();
            if (i % 2 == 0) {
                offset = offset.func_176734_d();
            }
            BlockPos projPos = pos.func_177967_a(offset, i);
            projPos = projPos.func_177963_a(0.0, 1.5, 0.0);
            EntityProjectileSpell spell = new EntityProjectileSpell(world, shooter, this.resolver, numPierce);
            spell.func_70107_b(projPos.func_177958_n(), projPos.func_177956_o(), projPos.func_177952_p());
            projectiles.add(spell);
        }
        float velocity = 1.0f + (float)MethodProjectile.getBuffCount(augments, AugmentAccelerate.class);
        for (EntityProjectileSpell proj : projectiles) {
            proj.func_184547_a((Entity)shooter, 90.0f, 90.0f, 0.0f, velocity, 0.0f);
            world.func_217376_c((Entity)proj);
        }
    }

    @Override
    public void onCast(ItemStack stack, LivingEntity shooter, World world, List<AbstractAugment> augments) {
        this.summonProjectiles(world, shooter, augments);
        this.resolver.expendMana(shooter);
    }

    @Override
    public void onCastOnBlock(ItemUseContext context, List<AbstractAugment> augments) {
        World world = context.func_195991_k();
        PlayerEntity shooter = context.func_195999_j();
        this.summonProjectiles(world, (LivingEntity)shooter, augments);
        this.resolver.expendMana((LivingEntity)shooter);
    }

    @Override
    public void onCastOnBlock(BlockRayTraceResult blockRayTraceResult, LivingEntity caster, List<AbstractAugment> augments) {
        caster.func_200602_a(EntityAnchorArgument.Type.EYES, blockRayTraceResult.func_216347_e());
        this.summonProjectiles(caster.func_130014_f_(), blockRayTraceResult.func_216350_a(), caster, augments);
        this.resolver.expendMana(caster);
    }

    @Override
    public void onCastOnEntity(ItemStack stack, LivingEntity caster, LivingEntity target, Hand hand, List<AbstractAugment> augments) {
        this.summonProjectiles(caster.func_130014_f_(), caster, augments);
        this.resolver.expendMana(caster);
    }

    @Override
    public boolean wouldCastSuccessfully(@Nullable ItemStack stack, LivingEntity playerEntity, World world, List<AbstractAugment> augments) {
        return true;
    }

    @Override
    public boolean wouldCastOnBlockSuccessfully(ItemUseContext context, List<AbstractAugment> augments) {
        return true;
    }

    @Override
    public boolean wouldCastOnBlockSuccessfully(BlockRayTraceResult blockRayTraceResult, LivingEntity caster, List<AbstractAugment> augments) {
        return true;
    }

    @Override
    public boolean wouldCastOnEntitySuccessfully(@Nullable ItemStack stack, LivingEntity caster, LivingEntity target, Hand hand, List<AbstractAugment> augments) {
        return true;
    }

    @Override
    protected String getBookDescription() {
        return "A spell you start with. Summons a projectile that applies spell effects when this projectile hits a target or block.";
    }
}

