/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.common.block.IntangibleAirBlock;
import com.hollingsworth.arsnouveau.common.block.tile.IntangibleAirTile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class IntangibleAirRenderer
extends TileEntityRenderer<IntangibleAirTile> {
    public IntangibleAirRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    private void renderModelBrightnessColorQuads(MatrixStack.Entry matrixEntry, IVertexBuilder builder, float red, float green, float blue, float alpha, List<BakedQuad> listQuads, int combinedLightsIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.func_178212_b()) {
                f = red * 1.0f;
                f1 = green * 1.0f;
                f2 = blue * 1.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            builder.addVertexData(matrixEntry, bakedquad, f, f1, f2, alpha, combinedLightsIn, combinedOverlayIn);
        }
    }

    public void render(IntangibleAirTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState renderState = Block.func_196257_b((int)tileEntityIn.stateID);
        if (renderState == null) {
            return;
        }
        double scale = (double)tileEntityIn.duration / (double)tileEntityIn.maxLength;
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(renderState);
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int color = blockColors.func_228054_a_(renderState, (IBlockDisplayReader)tileEntityIn.func_145831_w(), tileEntityIn.func_174877_v(), 0);
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        matrixStackIn.func_227860_a_();
        for (Direction direction : Direction.values()) {
            if (tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v().func_177972_a(direction)).func_177230_c() instanceof IntangibleAirBlock) continue;
            this.renderModelBrightnessColorQuads(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(DummyRender.RenderBlock), f, f1, f2, (float)scale, ibakedmodel.getQuads(renderState, direction, new Random(MathHelper.func_180186_a((Vector3i)tileEntityIn.func_174877_v())), (IModelData)EmptyModelData.INSTANCE), combinedLightIn, combinedOverlayIn);
        }
        matrixStackIn.func_227865_b_();
    }

    static class DummyRender
    extends RenderType {
        public static final RenderType RenderBlock = DummyRender.func_228632_a_((String)"MiningLaserRenderBlock", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228724_a_(field_228521_m_).func_228718_a_(field_239235_M_).func_228726_a_(field_228515_g_).func_228715_a_(field_228494_D_).func_228714_a_(field_228534_z_).func_228727_a_(field_228496_F_).func_228728_a_(false));

        public DummyRender(String nameIn, VertexFormat formatIn, int drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
        }
    }
}

