/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.google.common.cache.LoadingCache;
import com.hollingsworth.arsnouveau.common.block.ModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.PortalTile;
import com.hollingsworth.arsnouveau.common.datagen.Recipes;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PortalBlock
extends ModBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)14.0);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public PortalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200948_a(-1.0f, 3600000.0f).func_222380_e(), "portal");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d1 = (double)pos.func_177956_o() + (double)rand.nextFloat();
            double d2 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (worldIn.func_175625_s(hit.func_216350_a()) instanceof PortalTile) {
            ((PortalTile)worldIn.func_175625_s(hit.func_216350_a())).warp((Entity)projectile);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.func_175625_s(pos) instanceof PortalTile && !(entityIn instanceof PlayerEntity)) {
            ((PortalTile)worldIn.func_175625_s(pos)).warp(entityIn);
            entityIn.field_70143_R = 0.0f;
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PortalTile();
    }

    public boolean trySpawnPortal(IWorld worldIn, BlockPos pos, BlockPos warpPos, String dimID, Vector2f rotation, String displayName) {
        Size portalblock$size = this.isPortal(worldIn, pos);
        if (portalblock$size != null) {
            portalblock$size.placePortalBlocks(warpPos, dimID, rotation, displayName);
            return true;
        }
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, direction$axis1).isComplete() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    @Nullable
    public Size isPortal(IWorld worldIn, BlockPos pos) {
        Size portalblock$size = new Size(worldIn, pos, Direction.Axis.X);
        if (portalblock$size.isValid() && portalblock$size.portalBlockCount == 0) {
            return portalblock$size;
        }
        Size portalblock$size1 = new Size(worldIn, pos, Direction.Axis.Z);
        return portalblock$size1.isValid() && portalblock$size1.portalBlockCount == 0 ? portalblock$size1 : null;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld world, BlockPos pos) {
        Direction.Axis direction$axis = Direction.Axis.Z;
        Size portalblock$size = new Size(world, pos, Direction.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)world, (boolean)true);
        if (!portalblock$size.isValid()) {
            direction$axis = Direction.Axis.X;
            portalblock$size = new Size(world, pos, Direction.Axis.Z);
        }
        if (!portalblock$size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = portalblock$size.rightDir.func_176735_f();
        BlockPos blockpos = portalblock$size.bottomLeft.func_177981_b(portalblock$size.getHeight() - 1);
        for (Direction.AxisDirection direction$axisdirection : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection ? blockpos : blockpos.func_177967_a(portalblock$size.rightDir, portalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection, (Direction.Axis)direction$axis), Direction.UP, loadingcache, portalblock$size.getWidth(), portalblock$size.getHeight(), 1);
            for (int i = 0; i < portalblock$size.getWidth(); ++i) {
                for (int j = 0; j < portalblock$size.getHeight(); ++j) {
                    CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                    int n = direction$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection direction$axisdirection1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection direction$axisdirection2 : Direction.AxisDirection.values()) {
            if (aint[direction$axisdirection2.ordinal()] >= aint[direction$axisdirection1.ordinal()]) continue;
            direction$axisdirection1 = direction$axisdirection2;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection1 ? blockpos : blockpos.func_177967_a(portalblock$size.rightDir, portalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection1, (Direction.Axis)direction$axis), Direction.UP, loadingcache, portalblock$size.getWidth(), portalblock$size.getHeight(), 1);
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private BlockPos warpPos;
        private int dimId;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
            this.world = worldIn;
            this.axis = axisIn;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.canReplace(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canReplace(this.world.func_180495_p(blockpos = pos.func_177967_a(directionIn, i))) && this.isPortalFrame(this.world, blockpos.func_177977_b()); ++i) {
            }
            BlockPos framePos = pos.func_177967_a(directionIn, i);
            return this.isPortalFrame(this.world, framePos) ? i : 0;
        }

        public boolean isPortalFrame(IWorld world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c().func_203417_a(Recipes.DECORATIVE_AN);
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.canReplace(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == BlockRegistry.PORTAL_BLOCK) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.isPortalFrame(this.world, framePos = blockpos.func_177972_a(this.leftDir)) : i == this.width - 1 && !this.isPortalFrame(this.world, framePos = blockpos.func_177972_a(this.rightDir))) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                if (this.isPortalFrame(this.world, framePos)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canReplace(BlockState pos) {
            Block block = pos.func_177230_c();
            return pos.func_196958_f() || block == Blocks.field_150480_ab || block == BlockRegistry.PORTAL_BLOCK;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks(BlockPos warpPos, String dimId, Vector2f rotation, String displayName) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)BlockRegistry.PORTAL_BLOCK.func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 18);
                    if (!(this.world.func_175625_s(blockpos.func_177981_b(j)) instanceof PortalTile)) continue;
                    PortalTile tile = (PortalTile)this.world.func_175625_s(blockpos.func_177981_b(j));
                    tile.warpPos = warpPos;
                    tile.dimID = dimId;
                    tile.rotationVec = rotation;
                    tile.displayName = displayName;
                    tile.update();
                }
            }
        }

        private boolean rightSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean isComplete() {
            return this.isValid() && this.rightSize();
        }
    }
}

