/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.mana.AbstractManaTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ArcaneRelayTile
extends AbstractManaTile
implements ITooltipProvider,
IWandable,
IAnimatable {
    private BlockPos toPos;
    private BlockPos fromPos;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ArcaneRelayTile() {
        super(BlockRegistry.ARCANE_RELAY_TILE);
    }

    public ArcaneRelayTile(TileEntityType<?> type) {
        super(type);
    }

    public BlockPos getToPos() {
        return this.toPos;
    }

    public void setToPos(BlockPos toPos) {
        this.toPos = toPos;
    }

    public BlockPos getFromPos() {
        return this.fromPos;
    }

    public void setFromPos(BlockPos fromPos) {
        this.fromPos = fromPos;
    }

    public boolean setTakeFrom(BlockPos pos) {
        if (BlockUtil.distanceFrom(pos, this.field_174879_c) > (double)this.getMaxDistance()) {
            return false;
        }
        this.fromPos = pos;
        this.update();
        return true;
    }

    public boolean setSendTo(BlockPos pos) {
        if (BlockUtil.distanceFrom(pos, this.field_174879_c) > (double)this.getMaxDistance()) {
            return false;
        }
        this.toPos = pos;
        this.update();
        return true;
    }

    public int getMaxDistance() {
        return 30;
    }

    public void clearPos() {
        this.toPos = null;
        this.fromPos = null;
        this.update();
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public boolean closeEnough(BlockPos pos) {
        return BlockUtil.distanceFrom(pos, this.field_174879_c) <= (double)this.getMaxDistance();
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.setSendTo(storedPos.func_185334_h())) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.connections.send", new Object[]{DominionWand.getPosString(storedPos)}));
            ParticleUtil.beam(storedPos, this.field_174879_c, (World)((ServerWorld)this.field_145850_b));
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.connections.fail"));
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.field_145850_b.func_175625_s(storedPos) instanceof ArcaneRelayTile) {
            return;
        }
        if (this.setTakeFrom(storedPos.func_185334_h())) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.connections.take", new Object[]{DominionWand.getPosString(storedPos)}));
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.connections.fail"));
        }
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        this.clearPos();
        PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.connections.cleared"));
    }

    public void spawnParticles() {
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        if (this.fromPos != null) {
            AbstractManaTile fromTile;
            if (!(this.field_145850_b.func_175625_s(this.fromPos) instanceof AbstractManaTile)) {
                this.fromPos = null;
                this.update();
                return;
            }
            if (this.field_145850_b.func_175625_s(this.fromPos) instanceof AbstractManaTile && this.transferMana(fromTile = (AbstractManaTile)this.field_145850_b.func_175625_s(this.fromPos), this) > 0) {
                this.update();
                ParticleUtil.spawnFollowProjectile(this.field_145850_b, this.fromPos, this.field_174879_c);
            }
        }
        if (this.toPos == null) {
            return;
        }
        if (!(this.field_145850_b.func_175625_s(this.toPos) instanceof AbstractManaTile)) {
            this.toPos = null;
            this.update();
            return;
        }
        AbstractManaTile toTile = (AbstractManaTile)this.field_145850_b.func_175625_s(this.toPos);
        if (this.transferMana(this, toTile) > 0) {
            ParticleUtil.spawnFollowProjectile(this.field_145850_b, this.field_174879_c, this.toPos);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.toPos = NBTUtil.hasBlockPos(tag, "to") ? NBTUtil.getBlockPos(tag, "to") : null;
        this.fromPos = NBTUtil.hasBlockPos(tag, "from") ? NBTUtil.getBlockPos(tag, "from") : null;
        super.func_230337_a_(state, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.toPos != null) {
            NBTUtil.storeBlockPos(tag, "to", this.toPos);
        } else {
            NBTUtil.removeBlockPos(tag, "to");
        }
        if (this.fromPos != null) {
            NBTUtil.storeBlockPos(tag, "from", this.fromPos);
        } else {
            NBTUtil.removeBlockPos(tag, "from");
        }
        return super.func_189515_b(tag);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.toPos == null) {
            list.add(new TranslationTextComponent("ars_nouveau.relay.no_to").getString());
        } else {
            list.add(new TranslationTextComponent("ars_nouveau.relay.one_to", new Object[]{1}).getString());
        }
        if (this.fromPos == null) {
            list.add(new TranslationTextComponent("ars_nouveau.relay.no_from").getString());
        } else {
            list.add(new TranslationTextComponent("ars_nouveau.relay.one_from", new Object[]{1}).getString());
        }
        return list;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "rotate_controller", 0.0f, this::idlePredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "float_controller", 0.0f, this::floatPredicate));
    }

    private <P extends IAnimatable> PlayState idlePredicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("floating", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState floatPredicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("rotation", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

