/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class PotionMelderTile
extends TileEntity
implements IAnimatable,
ITickableTileEntity {
    int timeMixing;
    boolean isMixing;
    boolean hasMana;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);

    public PotionMelderTile() {
        super(BlockRegistry.POTION_MELDER_TYPE);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.hasMana && this.field_145850_b.func_82737_E() % 20L == 0L && ManaUtil.takeManaNearbyWithParticles(this.field_174879_c, this.field_145850_b, 5, 100) != null) {
            this.hasMana = true;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        if (!this.hasMana) {
            return;
        }
        PotionJarTile tile1 = null;
        PotionJarTile tile2 = null;
        for (Direction d : Direction.values()) {
            if (d == Direction.UP || d == Direction.DOWN) continue;
            if (tile1 != null && tile2 != null) break;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
            if (!(tileEntity instanceof PotionJarTile) || ((PotionJarTile)tileEntity).getAmount() <= 0) continue;
            if (tile1 == null) {
                tile1 = (PotionJarTile)tileEntity;
                continue;
            }
            tile2 = (PotionJarTile)tileEntity;
        }
        if (tile1 == null || tile2 == null || tile1.getAmount() < 300 || tile2.getAmount() < 300) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        PotionJarTile combJar = null;
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b()) instanceof PotionJarTile) {
            combJar = (PotionJarTile)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        if (combJar == null) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        List<EffectInstance> combined = this.getCombinedResult(tile1, tile2);
        if (!(combJar.isMixEqual(combined) && combJar.getMaxFill() - combJar.getCurrentFill() >= 100 || combJar.getAmount() == 0)) {
            this.isMixing = false;
            this.timeMixing = 0;
            return;
        }
        this.isMixing = true;
        ++this.timeMixing;
        ParticleColor color1 = ParticleColor.fromInt(tile1.getColor());
        ParticleColor color2 = ParticleColor.fromInt(tile2.getColor());
        if (this.field_145850_b.field_72995_K) {
            if (this.timeMixing >= 80 && combJar.getPotion() != Potions.field_185229_a) {
                for (int i = 0; i < 3; ++i) {
                    double d0 = (double)this.field_174879_c.func_177958_n() + 0.5 + ParticleUtil.inRange(-0.25, 0.25);
                    double d1 = (double)(this.field_174879_c.func_177956_o() + 1) + ParticleUtil.inRange(-0.1, 0.4);
                    double d2 = (double)this.field_174879_c.func_177952_p() + 0.5 + ParticleUtil.inRange(-0.25, 0.25);
                    this.field_145850_b.func_195594_a(GlowParticleData.createData(ParticleColor.fromInt(combJar.getColor())), d0, d1, d2, 0.0, (double)0.01f, 0.0);
                }
            }
            int offset = 30;
            if (this.timeMixing >= 60) {
                this.field_145850_b.func_195594_a(GlowParticleData.createData(color1), (double)this.field_174879_c.func_177958_n() + 0.5 - Math.sin((double)ClientInfo.ticksInGame / 8.0) / 4.0, (double)this.field_174879_c.func_177956_o() + 0.75 - Math.pow(Math.sin((double)ClientInfo.ticksInGame / 32.0), 2.0) / 2.0, (double)this.field_174879_c.func_177952_p() + 0.5 - Math.cos((double)ClientInfo.ticksInGame / 8.0) / 4.0, 0.0, 0.0, 0.0);
                this.field_145850_b.func_195594_a(GlowParticleData.createData(color2), (double)this.field_174879_c.func_177958_n() + 0.5 - Math.sin((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, (double)this.field_174879_c.func_177956_o() + 0.75 - Math.pow(Math.sin((double)(ClientInfo.ticksInGame + offset) / 32.0), 2.0) / 2.0, (double)this.field_174879_c.func_177952_p() + 0.5 - Math.cos((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, 0.0, 0.0, 0.0);
            }
            if (this.timeMixing >= 80) {
                offset = 50;
                this.field_145850_b.func_195594_a(GlowParticleData.createData(color1), (double)this.field_174879_c.func_177958_n() + 0.5 - Math.sin((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, (double)this.field_174879_c.func_177956_o() + 0.75 - Math.pow(Math.sin((double)(ClientInfo.ticksInGame + offset) / 32.0), 2.0) / 2.0, (double)this.field_174879_c.func_177952_p() + 0.5 - Math.cos((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, 0.0, 0.0, 0.0);
                offset = 70;
                this.field_145850_b.func_195594_a(GlowParticleData.createData(color2), (double)this.field_174879_c.func_177958_n() + 0.5 - Math.sin((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, (double)this.field_174879_c.func_177956_o() + 0.75 - Math.pow(Math.sin((double)(ClientInfo.ticksInGame + offset) / 32.0), 2.0) / 2.0, (double)this.field_174879_c.func_177952_p() + 0.5 - Math.cos((double)(ClientInfo.ticksInGame + offset) / 8.0) / 4.0, 0.0, 0.0, 0.0);
            }
            if (this.timeMixing >= 120) {
                this.timeMixing = 0;
            }
            return;
        }
        if (this.timeMixing % 20 == 0 && this.timeMixing > 0 && this.timeMixing <= 60) {
            EntityFlyingItem item = new EntityFlyingItem(this.field_145850_b, tile1.func_174877_v().func_177984_a(), this.field_174879_c, Math.round(255.0f * color1.getRed()), Math.round(255.0f * color1.getGreen()), Math.round(255.0f * color1.getBlue())).withNoTouch();
            item.setDistanceAdjust(2.0f);
            this.field_145850_b.func_217376_c((Entity)item);
            EntityFlyingItem item2 = new EntityFlyingItem(this.field_145850_b, tile2.func_174877_v().func_177984_a(), this.field_174879_c, Math.round(255.0f * color2.getRed()), Math.round(255.0f * color2.getGreen()), Math.round(255.0f * color2.getBlue())).withNoTouch();
            item2.setDistanceAdjust(2.0f);
            this.field_145850_b.func_217376_c((Entity)item2);
        }
        if (!this.field_145850_b.field_72995_K && this.timeMixing >= 120) {
            ++this.timeMixing;
            if (this.timeMixing >= 120) {
                this.timeMixing = 0;
            }
            Potion jar1Potion = tile1.getPotion();
            if (combJar.getAmount() == 0) {
                combJar.setPotion(jar1Potion, combined);
                combJar.setFill(100);
                tile1.addAmount(-300);
                tile2.addAmount(-300);
                this.hasMana = false;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            } else if (combJar.isMixEqual(combined) && combJar.getMaxFill() - combJar.getCurrentFill() >= 100) {
                combJar.addAmount(100);
                tile1.addAmount(-300);
                tile2.addAmount(-300);
                this.hasMana = false;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        }
    }

    public List<EffectInstance> getCombinedCustomResult(PotionJarTile jar1, PotionJarTile jar2) {
        HashSet<EffectInstance> set = new HashSet<EffectInstance>();
        set.addAll(jar1.getCustomEffects());
        set.addAll(jar2.getCustomEffects());
        return new ArrayList<EffectInstance>(set);
    }

    public List<EffectInstance> getCombinedResult(PotionJarTile jar1, PotionJarTile jar2) {
        HashSet<EffectInstance> set = new HashSet<EffectInstance>();
        set.addAll(jar1.getFullEffects());
        set.addAll(jar2.getFullEffects());
        return new ArrayList<EffectInstance>(set);
    }

    private <E extends TileEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("spin", Boolean.valueOf(true)));
        return this.isMixing ? PlayState.CONTINUE : PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "rotate_controller", 0.0f, this::idlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.timeMixing = nbt.func_74762_e("mixing");
        this.isMixing = nbt.func_74767_n("isMixing");
        this.hasMana = nbt.func_74767_n("hasMana");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("mixing", this.timeMixing);
        compound.func_74757_a("isMixing", this.isMixing);
        compound.func_74757_a("hasMana", this.hasMana);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }
}

