/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.mana.AbstractManaTile;
import com.hollingsworth.arsnouveau.api.mana.IManaTile;
import com.hollingsworth.arsnouveau.api.mana.SourcelinkEventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SourcelinkTile
extends AbstractManaTile
implements IAnimatable {
    int progress;
    public boolean isDisabled = false;
    public boolean registered = false;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SourcelinkTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public void func_73660_a() {
        BlockPos jarPos;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 120L == 0L && this.usesEventQueue()) {
            SourcelinkEventQueue.addPosition(this.field_145850_b, this.field_174879_c);
            this.registered = true;
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L && this.getCurrentMana() > 0 && (jarPos = ManaUtil.canGiveManaClosest(this.field_174879_c, this.field_145850_b, 5)) != null) {
            this.transferMana(this, (IManaTile)this.field_145850_b.func_175625_s(jarPos));
            ParticleUtil.spawnFollowProjectile(this.field_145850_b, this.field_174879_c, jarPos);
        }
    }

    public void getManaEvent(BlockPos sourcePos, int total) {
        this.addMana(total);
        ParticleUtil.spawnFollowProjectile(this.field_145850_b, sourcePos, this.field_174879_c);
    }

    public boolean eventInRange(BlockPos sourcePos, @Nullable Event event) {
        return BlockUtil.distanceFrom(this.field_174879_c, sourcePos) <= 15.0;
    }

    public boolean usesEventQueue() {
        return false;
    }

    public void doRandomAction() {
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "rotate_controller", 0.0f, this::idlePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74762_e("progress");
        this.isDisabled = tag.func_74767_n("disabled");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("progress", this.progress);
        tag.func_74757_a("disabled", this.isDisabled);
        return super.func_189515_b(tag);
    }

    private <E extends TileEntity> PlayState idlePredicate(AnimationEvent<E> event) {
        if (this.isDisabled) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("rotation", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }
}

