/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.SourcelinkTile;
import com.hollingsworth.arsnouveau.common.datagen.Recipes;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;

public class VolcanicSourcelinkTile
extends SourcelinkTile
implements IAnimatable {
    public VolcanicSourcelinkTile() {
        super(BlockRegistry.VOLCANIC_TILE);
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.canAcceptMana()) {
            for (ItemEntity i : this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0))) {
                int mana = 0;
                int progress = 0;
                int burnTime = ForgeHooks.getBurnTime((ItemStack)i.func_92059_d(), null);
                if (burnTime > 0) {
                    mana = burnTime / 12;
                    progress = 1;
                }
                if (i.func_92059_d().func_77973_b() == BlockRegistry.BLAZING_LOG.func_199767_j()) {
                    mana += 100;
                    progress += 5;
                } else if (i.func_92059_d().func_77973_b().func_206844_a(Recipes.ARCHWOOD_LOG_TAG)) {
                    mana += 50;
                    progress += 3;
                }
                if (mana <= 0) continue;
                this.progress += progress;
                this.addMana(mana);
                ItemStack containerItem = i.func_92059_d().getContainerItem();
                i.func_92059_d().func_190918_g(1);
                if (!containerItem.func_190926_b()) {
                    this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, i.func_226277_ct_(), i.func_226278_cu_(), i.func_226281_cx_(), containerItem));
                }
                Networking.sendToNearby(this.field_145850_b, this.func_174877_v(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, i.func_233580_cy_(), new ParticleColor.IntWrapper(255, 0, 0), new int[0]));
                return;
            }
        }
    }

    @Override
    public void doRandomAction() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AtomicBoolean set = new AtomicBoolean(false);
        BlockPos.func_239588_b_((BlockPos)this.field_174879_c, (int)1, (int)0, (int)1).forEach(p -> {
            if (!set.get() && this.field_145850_b.func_180495_p(p).func_196958_f() && this.field_145850_b.func_204610_c(p.func_177977_b()).func_206886_c() == Fluids.field_204547_b || this.field_145850_b.func_204610_c(p.func_177977_b()).func_206886_c() == Fluids.field_207213_d) {
                this.field_145850_b.func_175656_a(p, BlockRegistry.LAVA_LILY.getState(this.field_145850_b, (BlockPos)p));
                set.set(true);
            }
        });
        BlockPos magmaPos = this.getBlockInArea(Blocks.field_196814_hQ, 1);
        if (magmaPos != null && this.progress >= 200) {
            this.field_145850_b.func_175656_a(magmaPos, Blocks.field_150353_l.func_176223_P());
            this.progress -= 200;
            return;
        }
        BlockPos stonePos = this.getBlockInArea(Blocks.field_150348_b, 1);
        if (stonePos != null && this.progress >= 150) {
            this.field_145850_b.func_175656_a(stonePos, Blocks.field_196814_hQ.func_176223_P());
            this.progress -= 150;
            return;
        }
        stonePos = this.getTagInArea((ITag<Block>)Tags.Blocks.STONE, 1);
        if (stonePos != null && this.progress >= 150) {
            this.field_145850_b.func_175656_a(stonePos, Blocks.field_196814_hQ.func_176223_P());
            this.progress -= 150;
            return;
        }
    }

    public BlockPos getTagInArea(ITag<Block> block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(range, -1, range), (BlockPos)this.field_174879_c.func_177982_a(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (posFound.get() == null && this.field_145850_b.func_180495_p(blockPos).func_177230_c().func_203417_a(block)) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    public BlockPos getBlockInArea(Block block, int range) {
        AtomicReference posFound = new AtomicReference();
        BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(range, -1, range), (BlockPos)this.field_174879_c.func_177982_a(-range, -1, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (posFound.get() == null && this.field_145850_b.func_180495_p(blockPos).func_177230_c() == block) {
                posFound.set(blockPos);
            }
        });
        return (BlockPos)posFound.get();
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }
}

