/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.common.datagen.BlockStatesDatagen;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        ((ItemModelBuilder)this.getBuilder("glyph")).texture("layer0", this.itemTexture(ItemsRegistry.noviceSpellBook));
        ItemsRegistry.RegistrationHandler.ITEMS.forEach(i -> {
            if (i instanceof Glyph) {
                try {
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("glyph_" + ((Glyph)i).spellPart.getTag())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.spellTexture((Item)i));
                }
                catch (Exception e) {
                    System.out.println("No texture for " + i.toString());
                }
            } else if (i instanceof RitualTablet) {
                try {
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("ritual_" + ((RitualTablet)i).ritual.getID())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.ritualTexture((Item)i));
                }
                catch (Exception e) {
                    System.out.println("No texture for " + i.toString());
                }
            } else if (i instanceof FamiliarScript) {
                try {
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("familiar_" + ((FamiliarScript)i).familiar.getId())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.ritualTexture((Item)i));
                }
                catch (Exception e) {
                    System.out.println("No texture for " + i.toString());
                }
            } else {
                try {
                    ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(i.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture((Item)i));
                }
                catch (Exception e) {
                    System.out.println("No texture for " + i.toString());
                }
            }
        });
        ((ItemModelBuilder)this.getBuilder("arcane_stone")).parent(BlockStatesDatagen.getUncheckedModel("arcane_stone"));
        ((ItemModelBuilder)this.getBuilder("ab_alternating")).parent(BlockStatesDatagen.getUncheckedModel("ab_alternating"));
        ((ItemModelBuilder)this.getBuilder("ab_basket")).parent(BlockStatesDatagen.getUncheckedModel("ab_basket"));
        ((ItemModelBuilder)this.getBuilder("ab_herring")).parent(BlockStatesDatagen.getUncheckedModel("ab_herring"));
        ((ItemModelBuilder)this.getBuilder("ab_mosaic")).parent(BlockStatesDatagen.getUncheckedModel("ab_mosaic"));
        ((ItemModelBuilder)this.getBuilder("ab_smooth")).parent(BlockStatesDatagen.getUncheckedModel("ab_smooth"));
        ((ItemModelBuilder)this.getBuilder("ab_smooth_slab")).parent(BlockStatesDatagen.getUncheckedModel("ab_smooth_slab"));
        ((ItemModelBuilder)this.getBuilder("ab_clover")).parent(BlockStatesDatagen.getUncheckedModel("ab_clover"));
        ((ItemModelBuilder)this.getBuilder("stripped_blue_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_blue_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_blue_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_blue_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("stripped_green_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_green_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_green_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_green_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("stripped_red_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_red_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_red_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_red_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("stripped_purple_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_purple_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_purple_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_purple_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("mana_gem_block")).parent(BlockStatesDatagen.getUncheckedModel("mana_gem_block"));
        ((ItemModelBuilder)this.getBuilder("sas_basket")).parent(BlockStatesDatagen.getUncheckedModel("sas_basket"));
        ((ItemModelBuilder)this.getBuilder("sas_clover")).parent(BlockStatesDatagen.getUncheckedModel("ab_clover"));
        ((ItemModelBuilder)this.getBuilder("sas_herring")).parent(BlockStatesDatagen.getUncheckedModel("sas_herring"));
        ((ItemModelBuilder)this.getBuilder("sas_mosaic")).parent(BlockStatesDatagen.getUncheckedModel("sas_mosaic"));
        ((ItemModelBuilder)this.getBuilder("sas_alternating")).parent(BlockStatesDatagen.getUncheckedModel("sas_alternating"));
        ((ItemModelBuilder)this.getBuilder("sas_ashlar")).parent(BlockStatesDatagen.getUncheckedModel("sas_ashlar"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ItemsRegistry.EXPERIENCE_GEM.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(ItemsRegistry.EXPERIENCE_GEM));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ItemsRegistry.GREATER_EXPERIENCE_GEM.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(ItemsRegistry.GREATER_EXPERIENCE_GEM));
        ((ItemModelBuilder)this.getBuilder("as_gold_alt")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_alt"));
        ((ItemModelBuilder)this.getBuilder("as_gold_ashlar")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_ashlar"));
        ((ItemModelBuilder)this.getBuilder("as_gold_basket")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_basket"));
        ((ItemModelBuilder)this.getBuilder("as_gold_clover")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_clover"));
        ((ItemModelBuilder)this.getBuilder("as_gold_herring")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_herring"));
        ((ItemModelBuilder)this.getBuilder("as_gold_mosaic")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_mosaic"));
        ((ItemModelBuilder)this.getBuilder("as_gold_slab")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_slab"));
        ((ItemModelBuilder)this.getBuilder("as_gold_stone")).parent(BlockStatesDatagen.getUncheckedModel("as_gold_stone"));
    }

    public String func_200397_b() {
        return "Ars Nouveau Item Models";
    }

    private ResourceLocation registryName(Item item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)item.getRegistryName(), (String)"Item %s has a null registry name", (Object)item);
    }

    private ResourceLocation itemTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.func_110624_b(), "items/" + name.func_110623_a());
    }

    private ResourceLocation spellTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.func_110624_b(), "items/" + name.func_110623_a().replace("glyph_", ""));
    }

    private ResourceLocation ritualTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.func_110624_b(), "items/" + name.func_110623_a());
    }
}

