/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.GetUnstuckGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.AvoidPlayerUntamedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.FindItem;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.ForageManaBerries;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.NonHoggingLook;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StoreItemGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.TakeItemGoal;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityCarbuncle
extends CreatureEntity
implements IAnimatable,
IDispellable,
ITooltipProvider,
IWandable {
    private BlockPos fromPos;
    private BlockPos toPos;
    public List<ItemStack> allowedItems;
    public List<ItemStack> ignoreItems;
    public boolean whitelist;
    public boolean blacklist;
    public List<BlockPos> TO_LIST = new ArrayList<BlockPos>();
    public List<BlockPos> FROM_LIST = new ArrayList<BlockPos>();
    public static final DataParameter<Integer> TO_POS = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> FROM_POS = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<ItemStack> HELD_ITEM = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<String> COLOR = EntityDataManager.func_187226_a(EntityCarbuncle.class, (IDataSerializer)DataSerializers.field_187194_d);
    public int backOff;
    public int tamingTime;
    public boolean isStuck;
    private int lastAABBCalc;
    private AxisAlignedBB cachedAAB;
    AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    private boolean setBehaviors;
    public static String[] carbyColors = new String[]{"purple", "orange", "blue", "red", "yellow", "green"};

    public EntityCarbuncle(EntityType<EntityCarbuncle> entityCarbuncleEntityType, World world) {
        super(entityCarbuncleEntityType, world);
        this.field_70138_W = 1.2f;
        this.addGoalsAfterConstructor();
    }

    public EntityCarbuncle(World world, boolean tamed) {
        super(ModEntities.ENTITY_CARBUNCLE_TYPE, world);
        this.setTamed(tamed);
        this.field_70138_W = 1.2f;
        this.addGoalsAfterConstructor();
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 1.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v || source == DamageSource.field_76369_e) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    private PlayState animationPredicate(AnimationEvent event) {
        if (event.isMoving() || this.field_70170_p.field_72995_K && PatchouliHandler.isPatchouliWorld()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    public void attemptTame() {
        if (!this.isTamed() && this.getHeldStack().func_77973_b() == Items.field_151074_bl) {
            ++this.tamingTime;
            if (this.tamingTime % 20 == 0 && !this.field_70170_p.func_201670_d()) {
                Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketANEffect(PacketANEffect.EffectType.TIMED_HELIX, this.func_233580_cy_(), new int[0]));
            }
            if (this.tamingTime > 60 && !this.field_70170_p.field_72995_K) {
                ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.carbuncleShard, 1 + this.field_70170_p.field_73012_v.nextInt(2));
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), stack));
                this.remove(false);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else if (this.tamingTime > 55 && this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.func_226277_ct_();
                    double d1 = this.func_226278_cu_() + 0.1;
                    double d2 = this.func_226281_cx_();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0, ((double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f) - 0.5) / 3.0);
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 10L == 0L && this.func_200200_C_().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.field_70180_af.func_187227_b(COLOR, (Object)carbyColors[this.field_70170_p.field_73012_v.nextInt(carbyColors.length)]);
        }
        if (!this.field_70170_p.field_72995_K) {
            ++this.lastAABBCalc;
        }
        if (this.backOff > 0 && !this.field_70170_p.field_72995_K) {
            --this.backOff;
        }
        if (this.field_70729_aU) {
            return;
        }
        Direction[] directions = Direction.values();
        if (this.getHeldStack().func_190926_b() && !this.field_70170_p.field_72995_K) {
            for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_186662_g(1.0))) {
                if (!itementity.func_70089_S() || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                if (!this.isTamed() && itementity.func_92059_d().func_77973_b() != Items.field_151074_bl) {
                    return;
                }
                this.func_175445_a(itementity);
                if (this.getHeldStack() == null || this.getHeldStack().func_190926_b()) continue;
                break;
            }
        }
        this.attemptTame();
    }

    @Override
    public void onWanded(PlayerEntity playerEntity) {
        this.whitelist = false;
        this.blacklist = false;
        this.FROM_LIST = new ArrayList<BlockPos>();
        this.TO_LIST = new ArrayList<BlockPos>();
        this.field_70180_af.func_187227_b(TO_POS, (Object)0);
        this.field_70180_af.func_187227_b(FROM_POS, (Object)0);
        PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.carbuncle.cleared"));
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.field_70170_p.func_175625_s(storedPos) != null && this.field_70170_p.func_175625_s(storedPos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.carbuncle.store"));
            this.setToPos(storedPos);
        }
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, PlayerEntity playerEntity) {
        if (storedPos == null) {
            return;
        }
        if (this.field_70170_p.func_175625_s(storedPos) != null && this.field_70170_p.func_175625_s(storedPos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            PortUtil.sendMessage((Entity)playerEntity, (ITextComponent)new TranslationTextComponent("ars_nouveau.carbuncle.take"));
            this.setFromPos(storedPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vec3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public static AttributeModifierMap.MutableAttribute attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        if (this.getHeldStack().func_190926_b() && this.isValidItem(itemEntity.func_92059_d())) {
            this.setHeldStack(itemEntity.func_92059_d());
            itemEntity.func_70106_y();
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, this.func_184176_by(), 1.0f, 1.0f);
            if (!this.isTamed()) {
                return;
            }
            for (ItemEntity i : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_186662_g(3.0))) {
                if (itemEntity.func_92059_d().func_190916_E() >= itemEntity.func_92059_d().func_77976_d()) break;
                int maxTake = this.getHeldStack().func_77976_d() - this.getHeldStack().func_190916_E();
                if (!i.func_92059_d().func_77969_a(this.getHeldStack())) continue;
                int toTake = Math.min(i.func_92059_d().func_190916_E(), maxTake);
                i.func_92059_d().func_190918_g(toTake);
                this.getHeldStack().func_190917_f(toTake);
            }
        }
    }

    protected void addGoalsAfterConstructor() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        for (PrioritizedGoal goal : this.getGoals()) {
            this.field_70714_bg.func_75776_a(goal.func_220770_h(), goal.func_220772_j());
        }
    }

    public List<PrioritizedGoal> getGoals() {
        return Boolean.TRUE.equals(this.field_70180_af.func_187225_a(TAMED)) ? this.getTamedGoals() : this.getUntamedGoals();
    }

    public BlockPos getHome() {
        if (this.FROM_LIST.isEmpty() && !this.TO_LIST.isEmpty()) {
            return this.TO_LIST.get(0);
        }
        if (this.TO_LIST.isEmpty() && !this.FROM_LIST.isEmpty()) {
            return this.FROM_LIST.get(0);
        }
        if (!this.TO_LIST.isEmpty()) {
            return this.FROM_LIST.get(0);
        }
        return null;
    }

    protected float func_189749_co() {
        return 0.875f;
    }

    public List<PrioritizedGoal> getTamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(1, (Goal)new GetUnstuckGoal((MobEntity)this, () -> this.isStuck, stuck -> {
            this.isStuck = stuck;
            return null;
        })));
        list.add(new PrioritizedGoal(1, (Goal)new FindItem(this)));
        list.add(new PrioritizedGoal(2, (Goal)new ForageManaBerries(this)));
        list.add(new PrioritizedGoal(3, (Goal)new StoreItemGoal(this)));
        list.add(new PrioritizedGoal(3, (Goal)new TakeItemGoal(this)));
        list.add(new PrioritizedGoal(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 0.01f)));
        list.add(new PrioritizedGoal(8, (Goal)new NonHoggingLook(this, MobEntity.class, 3.0f, 0.01f)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        return list;
    }

    public List<PrioritizedGoal> getUntamedGoals() {
        ArrayList<PrioritizedGoal> list = new ArrayList<PrioritizedGoal>();
        list.add(new PrioritizedGoal(1, (Goal)new FindItem(this)));
        list.add(new PrioritizedGoal(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 0.02f)));
        list.add(new PrioritizedGoal(4, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f)));
        list.add(new PrioritizedGoal(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0)));
        list.add(new PrioritizedGoal(2, (Goal)new AvoidPlayerUntamedGoal(this, PlayerEntity.class, 16.0f, 1.6, 1.4)));
        list.add(new PrioritizedGoal(0, (Goal)new SwimGoal((MobEntity)this)));
        return list;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.carbuncleCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            if (this.getHeldStack() != null) {
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getHeldStack()));
            }
        }
        super.func_70645_a(source);
    }

    public AxisAlignedBB getAABB() {
        if (this.cachedAAB == null || this.lastAABBCalc >= 60) {
            this.cachedAAB = new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(8.0);
            this.lastAABBCalc = 0;
        }
        return this.cachedAAB;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        List<ItemStack> items;
        if (hand != Hand.MAIN_HAND || player.func_130014_f_().field_72995_K || !this.isTamed()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184614_ca().func_77973_b().func_206844_a((ITag)Tags.Items.DYES)) {
            DyeColor color = DyeColor.getColor((ItemStack)stack);
            if (color == null || ((String)this.field_70180_af.func_187225_a(COLOR)).equals(color.func_176762_d()) || !Arrays.asList(carbyColors).contains(color.func_176762_d())) {
                return ActionResultType.SUCCESS;
            }
            this.field_70180_af.func_187227_b(COLOR, (Object)color.func_176762_d());
            player.func_184614_ca().func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        if (player.func_184614_ca().func_190926_b() && this.isTamed()) {
            StringBuilder status = new StringBuilder();
            if (this.whitelist && this.allowedItems != null) {
                status.append(new TranslationTextComponent("ars_nouveau.carbuncle.whitelist").getString());
                for (ItemStack i : this.allowedItems) {
                    status.append(i.func_200301_q().getString());
                }
            } else if (this.blacklist && this.allowedItems != null) {
                status.append(new TranslationTextComponent("ars_nouveau.carbuncle.blacklist").getString());
                for (ItemStack i : this.ignoreItems) {
                    status.append(i.func_200301_q().getString());
                }
            }
            if (!status.toString().isEmpty()) {
                PortUtil.sendMessage((Entity)player, status.toString());
            }
        }
        if (!(stack.func_77973_b() instanceof ItemScroll) || !stack.func_77942_o()) {
            return ActionResultType.FAIL;
        }
        if (stack.func_77973_b() == ItemsRegistry.ALLOW_ITEM_SCROLL) {
            items = ItemsRegistry.ALLOW_ITEM_SCROLL.getItems(stack);
            if (!items.isEmpty()) {
                this.allowedItems = ItemsRegistry.ALLOW_ITEM_SCROLL.getItems(stack);
                this.whitelist = true;
                this.blacklist = false;
                PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.allow_set"));
            }
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() == ItemsRegistry.DENY_ITEM_SCROLL && !(items = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack)).isEmpty()) {
            this.ignoreItems = ItemsRegistry.DENY_ITEM_SCROLL.getItems(stack);
            this.whitelist = false;
            this.blacklist = true;
            PortUtil.sendMessage((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.ignore_set"));
        }
        return ActionResultType.SUCCESS;
    }

    public EntityType<?> func_200600_R() {
        return ModEntities.ENTITY_CARBUNCLE_TYPE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELD_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(TO_POS, (Object)0);
        this.field_70180_af.func_187214_a(FROM_POS, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)COLORS.ORANGE.name());
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void setHeldStack(ItemStack stack) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
    }

    public ItemStack getHeldStack() {
        return this.func_184614_ca();
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.field_70128_L) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            ItemStack stack = new ItemStack((IItemProvider)ItemsRegistry.carbuncleCharm);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack.func_77946_l()));
            stack = this.getHeldStack();
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
            ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_());
            this.func_70106_y();
        }
        return this.isTamed();
    }

    public void func_70037_a(CompoundNBT tag) {
        BlockPos oldFromPos;
        BlockPos pos;
        super.func_70037_a(tag);
        if (tag.func_74764_b("held")) {
            this.setHeldStack(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag.func_74781_a("held"))));
        }
        this.FROM_LIST = new ArrayList<BlockPos>();
        this.TO_LIST = new ArrayList<BlockPos>();
        int counter = 0;
        while (NBTUtil.hasBlockPos(tag, "from_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "from_" + counter);
            if (!this.FROM_LIST.contains(pos)) {
                this.FROM_LIST.add(pos);
            }
            ++counter;
        }
        counter = 0;
        while (NBTUtil.hasBlockPos(tag, "to_" + counter)) {
            pos = NBTUtil.getBlockPos(tag, "to_" + counter);
            if (!this.TO_LIST.contains(pos)) {
                this.TO_LIST.add(pos);
            }
            ++counter;
        }
        BlockPos oldToPos = NBTUtil.getBlockPos(tag, "to");
        if (!oldToPos.equals((Object)new BlockPos(0, 0, 0)) && !this.TO_LIST.contains(oldToPos)) {
            this.TO_LIST.add(oldToPos);
        }
        if (!(oldFromPos = NBTUtil.getBlockPos(tag, "from")).equals((Object)new BlockPos(0, 0, 0)) && !this.FROM_LIST.contains(oldFromPos)) {
            this.FROM_LIST.add(oldFromPos);
        }
        this.backOff = tag.func_74762_e("backoff");
        this.tamingTime = tag.func_74762_e("taming_time");
        this.whitelist = tag.func_74767_n("whitelist");
        this.blacklist = tag.func_74767_n("blacklist");
        if (!this.setBehaviors) {
            this.removeGoals();
        }
        this.field_70180_af.func_187227_b(TAMED, (Object)tag.func_74767_n("tamed"));
        if (!this.setBehaviors) {
            this.addGoalsAfterConstructor();
            this.setBehaviors = true;
        }
        this.allowedItems = NBTUtil.readItems(tag, "allowed_");
        this.ignoreItems = NBTUtil.readItems(tag, "ignored_");
        this.isStuck = tag.func_74767_n("stuck");
        if (tag.func_74764_b("color")) {
            this.field_70180_af.func_187227_b(COLOR, (Object)tag.func_74779_i("color"));
        }
        this.field_70180_af.func_187227_b(TO_POS, (Object)this.TO_LIST.size());
        this.field_70180_af.func_187227_b(FROM_POS, (Object)this.FROM_LIST.size());
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.getHeldStack() != null) {
            CompoundNBT itemTag = new CompoundNBT();
            this.getHeldStack().func_77955_b(itemTag);
            tag.func_218657_a("held", (INBT)itemTag);
        }
        int counter = 0;
        for (BlockPos p : this.FROM_LIST) {
            NBTUtil.storeBlockPos(tag, "from_" + counter, p);
            ++counter;
        }
        counter = 0;
        for (BlockPos p : this.TO_LIST) {
            NBTUtil.storeBlockPos(tag, "to_" + counter, p);
            ++counter;
        }
        tag.func_74768_a("backoff", this.backOff);
        tag.func_74757_a("tamed", ((Boolean)this.field_70180_af.func_187225_a(TAMED)).booleanValue());
        tag.func_74768_a("taming_time", this.tamingTime);
        tag.func_74757_a("whitelist", this.whitelist);
        tag.func_74757_a("blacklist", this.blacklist);
        if (this.allowedItems != null && !this.allowedItems.isEmpty()) {
            NBTUtil.writeItems(tag, "allowed_", this.allowedItems);
        }
        if (this.ignoreItems != null && !this.ignoreItems.isEmpty()) {
            NBTUtil.writeItems(tag, "ignored_", this.ignoreItems);
        }
        tag.func_74757_a("stuck", this.isStuck);
        tag.func_74778_a("color", (String)this.field_70180_af.func_187225_a(COLOR));
    }

    public void removeGoals() {
        this.field_70714_bg.field_220892_d = new LinkedHashSet();
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> toolTip = new ArrayList<String>();
        if (!this.isTamed()) {
            return toolTip;
        }
        toolTip.add(new TranslationTextComponent("ars_nouveau.carbuncle.storing", new Object[]{this.field_70180_af.func_187225_a(TO_POS)}).getString());
        toolTip.add(new TranslationTextComponent("ars_nouveau.carbuncle.taking", new Object[]{this.field_70180_af.func_187225_a(FROM_POS)}).getString());
        return toolTip;
    }

    private ItemScroll.SortPref canDepositItem(TileEntity tile, ItemStack stack) {
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (tile == null || stack == null || stack.func_190926_b()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        for (ItemFrameEntity i : this.field_70170_p.func_217357_a(ItemFrameEntity.class, new AxisAlignedBB(tile.func_174877_v()).func_186662_g(1.0))) {
            TileEntity adjTile = this.field_70170_p.func_175625_s(i.func_233580_cy_().func_177972_a(i.func_174811_aO().func_176734_d()));
            if (adjTile == null || !adjTile.equals(tile) || i.func_82335_i().func_190926_b()) continue;
            ItemStack stackInFrame = i.func_82335_i();
            if (stackInFrame.func_77973_b() instanceof ItemScroll) {
                pref = ((ItemScroll)stackInFrame.func_77973_b()).getSortPref(stack, stackInFrame.func_196082_o(), handler);
                continue;
            }
            if (i.func_82335_i().func_77973_b() != stack.func_77973_b()) {
                return ItemScroll.SortPref.INVALID;
            }
            if (i.func_82335_i().func_77973_b() != stack.func_77973_b()) continue;
            pref = ItemScroll.SortPref.HIGHEST;
        }
        return !ItemStack.func_77989_b((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    public BlockPos getValidStorePos(ItemStack stack) {
        BlockPos returnPos = null;
        if (this.TO_LIST == null) {
            return returnPos;
        }
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : this.TO_LIST) {
            ItemScroll.SortPref pref = this.canDepositItem(this.field_70170_p.func_175625_s(b), stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
        }
        return returnPos;
    }

    public BlockPos getValidTakePos() {
        if (this.FROM_LIST == null) {
            return null;
        }
        for (BlockPos p : this.FROM_LIST) {
            IItemHandler iItemHandler;
            if (this.field_70170_p.func_175625_s(p) == null || (iItemHandler = (IItemHandler)this.field_70170_p.func_175625_s(p).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) == null) continue;
            for (int j = 0; j < iItemHandler.getSlots(); ++j) {
                if (iItemHandler.getStackInSlot(j).func_190926_b() || !this.isValidItem(iItemHandler.getStackInSlot(j)) || this.getValidStorePos(iItemHandler.getStackInSlot(j)) == null) continue;
                return p;
            }
        }
        return null;
    }

    public boolean func_241845_aY() {
        return false;
    }

    public boolean func_241849_j(Entity p_241849_1_) {
        return true;
    }

    public boolean isValidItem(ItemStack stack) {
        if (!this.isTamed() && stack.func_77973_b() == Items.field_151074_bl) {
            return true;
        }
        if (this.getValidStorePos(stack) == null) {
            return false;
        }
        if (!this.whitelist && !this.blacklist) {
            return true;
        }
        if (this.whitelist) {
            for (ItemStack s : this.allowedItems) {
                if (!s.func_77969_a(stack)) continue;
                return true;
            }
            return false;
        }
        if (this.blacklist) {
            for (ItemStack s : this.ignoreItems) {
                if (!s.func_77969_a(stack)) continue;
                return false;
            }
        }
        return true;
    }

    public void setFromPos(BlockPos fromPos) {
        if (!this.FROM_LIST.contains(fromPos)) {
            this.FROM_LIST.add(fromPos.func_185334_h());
        }
        this.field_70180_af.func_187227_b(FROM_POS, (Object)this.FROM_LIST.size());
    }

    public void setToPos(BlockPos toPos) {
        if (!this.TO_LIST.contains(toPos)) {
            this.TO_LIST.add(toPos.func_185334_h());
        }
        this.field_70180_af.func_187227_b(TO_POS, (Object)this.TO_LIST.size());
    }

    public static enum COLORS {
        ORANGE,
        PURPLE,
        GREEN;

    }
}

