/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenGuardian;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraAttackGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraDiveGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraRageGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraRamGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSpikeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.ChimeraSummonGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.potions.SnareEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityChimera
extends MonsterEntity
implements IAnimatable,
IAnimationListener {
    private final ServerBossInfo bossEvent = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true).func_186743_c(true).func_186742_b(true);
    public static final DataParameter<Boolean> HAS_SPIKES = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_HORNS = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> HAS_WINGS = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> DEFENSIVE_MODE = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> PHASE_SWAPPING = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> IS_FLYING = EntityDataManager.func_187226_a(EntityChimera.class, (IDataSerializer)DataSerializers.field_187198_h);
    public boolean isRamming;
    public int summonCooldown;
    public int diveCooldown;
    public int spikeCooldown;
    public int ramCooldown;
    public int rageTimer;
    public boolean diving;
    public FlyingPathNavigator flyingNavigator;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public Vector3d orbitOffset = Vector3d.field_186680_a;

    public EntityChimera(EntityType<? extends MonsterEntity> type, World level) {
        super(type, level);
        this.field_70765_h = new ChimeraMoveController(this, 10, true);
        this.field_70138_W = 2.0f;
        this.func_110163_bv();
        this.initFlyingNavigator();
        this.rageTimer = 300;
        this.field_70728_aV = 75;
    }

    public EntityChimera(World level) {
        this(ModEntities.WILDEN_BOSS, level);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new ChimeraAttackGoal(this, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new ChimeraSummonGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new ChimeraRageGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ChimeraRamGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ChimeraDiveGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ChimeraSpikeGoal(this));
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "walkController", 20.0f, this::groundPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 1.0f, this::attackPredicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "crouchController", 1.0f, this::crouchPredicate));
    }

    private <E extends Entity> PlayState attackPredicate(AnimationEvent event) {
        return PlayState.CONTINUE;
    }

    private <E extends Entity> PlayState crouchPredicate(AnimationEvent event) {
        if (this.isDefensive()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("crouch"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends Entity> PlayState groundPredicate(AnimationEvent e) {
        if (!this.isDefensive() && e.isMoving() && !this.isFlying()) {
            e.getController().setAnimation(new AnimationBuilder().addAnimation("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void func_70071_h_() {
        Path path;
        super.func_70071_h_();
        if (this.isDefensive()) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        if (this.field_70170_p.field_72995_K && this.isFlying() && this.field_70146_Z.nextInt(18) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_189108_z, this.func_184176_by(), 0.95f + this.field_70146_Z.nextFloat() * 0.05f, 0.3f + this.field_70146_Z.nextFloat() * 0.05f, false);
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70638_az() == null || this.field_70172_ad != 0 || this.isDefensive() || this.isFlying() || !this.field_70122_E || (path = this.func_70661_as().func_75494_a((Entity)this.func_70638_az(), 1)) != null && path.func_224771_h() && !(this.func_70638_az().func_226278_cu_() - (this.func_226278_cu_() + 2.0) >= 3.0))) {
            --this.rageTimer;
        }
        if (!this.isFlying()) {
            this.func_189654_d(this.func_180799_ab());
        }
        if (!this.field_70170_p.field_72995_K && this.func_180799_ab() && this.field_70170_p.func_82737_E() % 10L == 0L) {
            this.func_195064_c(new EffectInstance(Effects.field_76424_c, 20, 4));
            this.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 3));
            this.func_195064_c(new EffectInstance(Effects.field_76426_n, 20));
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 20, 3));
        }
        if (this.isFlying()) {
            this.field_70699_by.func_75499_g();
            this.flyingNavigator.func_75501_e();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying() && this.field_70714_bg.func_220888_c().noneMatch(g -> g.func_220772_j() instanceof ChimeraDiveGoal)) {
                this.setFlying(false);
            }
            if (this.isDefensive() && this.field_70714_bg.func_220888_c().noneMatch(g -> g.func_220772_j() instanceof ChimeraSpikeGoal)) {
                this.setDefensiveMode(false);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            if (this.diveCooldown > 0) {
                --this.diveCooldown;
                if (this.func_180799_ab() || this.func_70090_H()) {
                    this.spikeCooldown -= 2;
                }
            }
            if (this.spikeCooldown > 0) {
                --this.spikeCooldown;
            }
            if (this.ramCooldown > 0) {
                --this.ramCooldown;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getPhaseSwapping() && !this.field_70729_aU) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(2.0f);
            } else {
                this.func_195061_cb();
                this.setPhaseSwapping(false);
                for (LivingEntity e : this.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_233580_cy_()).func_186662_g(5.0))) {
                    EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(new Spell.Builder().add(MethodTouch.INSTANCE).add(EffectLaunch.INSTANCE).add(AugmentAmplify.INSTANCE, 2).add(EffectDelay.INSTANCE).add(EffectKnockback.INSTANCE).add(AugmentAmplify.INSTANCE, 2).build(), (LivingEntity)this));
                    resolver.onCastOnEntity(ItemStack.field_190927_a, (LivingEntity)this, e, Hand.MAIN_HAND);
                }
                this.getRandomUpgrade();
                this.gainPhaseBuffs();
                ParticleUtil.spawnPoof((ServerWorld)this.field_70170_p, this.func_233580_cy_().func_177984_a());
                if (this.getPhase() == 1) {
                    this.rageTimer = 200;
                }
            }
        }
        if (this.getPhaseSwapping() && this.field_70170_p.field_72995_K) {
            EntityChimera.spawnPhaseParticles(this.func_233580_cy_(), this.field_70170_p, this.getPhase());
        }
    }

    public static void spawnPhaseParticles(BlockPos pos, World level, int multiplier) {
        if (!level.field_72995_K) {
            return;
        }
        int baseAge = 40;
        float scaleAge = (float)ParticleUtil.inRange(0.1, 0.2);
        for (int i = 0; i < 10 * Math.min(1, multiplier); ++i) {
            Vector3d particlePos = new Vector3d((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
            particlePos = particlePos.func_178787_e(ParticleUtil.pointInSphere().func_216372_d(3.0, 3.0, 3.0));
            level.func_195594_a(ParticleLineData.createData(ParticleColor.makeRandomColor(255, 255, 255, level.field_73012_v), scaleAge, baseAge + level.field_73012_v.nextInt(20)), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        ItemEntity itementity = this.func_199703_a((IItemProvider)ItemsRegistry.WILDEN_TRIBUTE);
        if (itementity != null) {
            itementity.func_174873_u();
        }
    }

    protected boolean func_230282_cS_() {
        return true;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f + this.field_70146_Z.nextFloat() * 0.3f, 0.8f + this.field_70146_Z.nextFloat() * 0.1f);
    }

    public boolean func_174814_R() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    public void gainPhaseBuffs() {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, 100 + 100 * this.getPhase(), 3));
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 300 + 300 * this.getPhase(), this.getPhase()));
        this.func_195064_c(new EffectInstance(Effects.field_76424_c, 300 + 300 * this.getPhase(), this.getPhase()));
    }

    public void resetCooldowns() {
        this.spikeCooldown = 0;
        this.ramCooldown = 0;
        this.diveCooldown = 0;
        this.summonCooldown = 0;
    }

    public void func_70691_i(float p_70691_1_) {
        this.func_70606_j(this.func_110143_aJ() + p_70691_1_);
    }

    public boolean canDive() {
        return !this.isRamming && this.diveCooldown <= 0 && this.hasWings() && !this.getPhaseSwapping() && !this.isFlying() && this.field_70122_E && !this.isDefensive();
    }

    public boolean canSpike() {
        return !this.isRamming && this.spikeCooldown <= 0 && this.hasSpikes() && !this.getPhaseSwapping() && !this.isFlying() && this.field_70122_E && this.func_70638_az() != null;
    }

    public boolean canRam() {
        return !this.isRamming && this.ramCooldown <= 0 && this.hasHorns() && !this.getPhaseSwapping() && !this.isFlying() && !this.isDefensive() && this.func_70638_az() != null && this.func_70638_az().func_233570_aj_() && this.func_233570_aj_();
    }

    public boolean canSummon() {
        return !this.isRamming && this.func_70638_az() != null && this.summonCooldown <= 0 && !this.isFlying() && !this.getPhaseSwapping() && !this.isDefensive() && this.field_70122_E;
    }

    public boolean canAttack() {
        return !this.isRamming && this.func_70638_az() != null && this.func_110143_aJ() >= 1.0f && !this.getPhaseSwapping() && !this.isFlying() && !this.isDefensive();
    }

    public boolean canRage() {
        return !this.getPhaseSwapping() && !this.isRamming;
    }

    public boolean func_233643_dh_() {
        return this.getPhase() > 3;
    }

    public void getRandomUpgrade() {
        ArrayList<Integer> upgrades = new ArrayList<Integer>();
        if (!this.hasWings()) {
            upgrades.add(0);
        }
        if (!this.hasSpikes()) {
            upgrades.add(1);
        }
        if (!this.hasHorns()) {
            upgrades.add(2);
        }
        if (upgrades.isEmpty()) {
            return;
        }
        int upgrade = (Integer)upgrades.get(this.field_70146_Z.nextInt(upgrades.size()));
        switch (upgrade) {
            case 0: {
                this.setWings(true);
                return;
            }
            case 1: {
                this.setSpikes(true);
                return;
            }
            case 2: {
                this.setHorns(true);
                return;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v || source == DamageSource.field_76368_d || source == DamageSource.field_76371_c || source == DamageSource.field_76369_e) {
            return false;
        }
        if (source.field_76373_n.equals("cold")) {
            amount /= 2.0f;
        }
        if (this.getPhaseSwapping()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof LivingEntity && !entity.equals((Object)this)) {
            LivingEntity entity1;
            if (this.isDefensive() && !source.field_76373_n.equals("thorns") && !source.func_76363_c() && BlockUtil.distanceFrom(entity.field_233557_ao_, this.field_233557_ao_) <= 3.0) {
                entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 6.0f);
            }
            if ((entity1 = (LivingEntity)entity) instanceof WildenStalker || entity1 instanceof WildenGuardian || entity instanceof WildenHunter || entity instanceof ISummon && ((ISummon)entity).getOwnerID() != null && ((ISummon)entity).getOwnerID().equals(this.func_110124_au()) || entity1 instanceof SummonWolf && ((SummonWolf)entity1).isWildenSummon) {
                return false;
            }
        }
        if (this.isDefensive()) {
            return false;
        }
        boolean res = super.func_70097_a(source, amount);
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() <= 0.0 && this.getPhase() < 3) {
            this.setPhaseSwapping(true);
            this.setPhase(this.getPhase() + 1);
            this.func_70661_as().func_75499_g();
            this.func_70606_j(1.0f);
            Networking.sendToNearby(this.field_70170_p, (Entity)this, (Object)new PacketAnimEntity(this.func_145782_y(), Animations.HOWL.ordinal()));
            this.setFlying(false);
            this.setDefensiveMode(false);
            this.isRamming = false;
            this.field_70729_aU = false;
        }
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() <= 0.0 && this.getPhase() == 3) {
            this.setPhase(4);
            super.func_70645_a(source);
        }
        return res;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossEvent.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected boolean func_184228_n(Entity p_184228_1_) {
        return false;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        } else {
            this.field_70708_bq = 0;
        }
    }

    public void func_184178_b(ServerPlayerEntity p_184178_1_) {
        super.func_184178_b(p_184178_1_);
        this.bossEvent.func_186760_a(p_184178_1_);
    }

    public void func_184203_c(ServerPlayerEntity p_184203_1_) {
        super.func_184203_c(p_184203_1_);
        this.bossEvent.func_186761_b(p_184203_1_);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70687_e(EffectInstance instance) {
        Effect effect = instance.func_188419_a();
        if (instance.func_188419_a() instanceof SnareEffect) {
            return false;
        }
        if (effect == Effects.field_76421_d) {
            instance = new EffectInstance(instance.func_188419_a(), 1, 0);
        }
        if (effect == ModPotions.GRAVITY_EFFECT) {
            instance = new EffectInstance(instance.func_188419_a(), Math.min(instance.func_76459_b(), 100), 0);
        }
        return super.func_70687_e(instance);
    }

    public int getCooldownModifier() {
        return 300 / (this.getPhase() + 1);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_HORNS, (Object)false);
        this.field_70180_af.func_187214_a(HAS_SPIKES, (Object)false);
        this.field_70180_af.func_187214_a(HAS_WINGS, (Object)false);
        this.field_70180_af.func_187214_a(PHASE, (Object)1);
        this.field_70180_af.func_187214_a(DEFENSIVE_MODE, (Object)false);
        this.field_70180_af.func_187214_a(PHASE_SWAPPING, (Object)false);
        this.field_70180_af.func_187214_a(IS_FLYING, (Object)false);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(IS_FLYING, (Object)flying);
    }

    public boolean hasHorns() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_HORNS);
    }

    public void setHorns(boolean hasHorns) {
        this.field_70180_af.func_187227_b(HAS_HORNS, (Object)hasHorns);
    }

    public boolean hasSpikes() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_SPIKES);
    }

    public void setSpikes(boolean hasSpikes) {
        this.field_70180_af.func_187227_b(HAS_SPIKES, (Object)hasSpikes);
    }

    public boolean hasWings() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_WINGS);
    }

    public void setWings(boolean hasWings) {
        this.field_70180_af.func_187227_b(HAS_WINGS, (Object)hasWings);
    }

    public boolean isDefensive() {
        return (Boolean)this.field_70180_af.func_187225_a(DEFENSIVE_MODE);
    }

    public void setDefensiveMode(boolean defensiveMode) {
        this.field_70180_af.func_187227_b(DEFENSIVE_MODE, (Object)defensiveMode);
    }

    public int getPhase() {
        return (Integer)this.field_70180_af.func_187225_a(PHASE);
    }

    public void setPhase(int phase) {
        this.field_70180_af.func_187227_b(PHASE, (Object)phase);
    }

    public boolean getPhaseSwapping() {
        return (Boolean)this.field_70180_af.func_187225_a(PHASE_SWAPPING);
    }

    public void setPhaseSwapping(boolean swapping) {
        this.field_70180_af.func_187227_b(PHASE_SWAPPING, (Object)swapping);
    }

    public void func_70020_e(CompoundNBT tag) {
        super.func_70020_e(tag);
        this.setHorns(tag.func_74767_n("horns"));
        this.setSpikes(tag.func_74767_n("spikes"));
        this.setWings(tag.func_74767_n("wings"));
        this.setPhase(tag.func_74762_e("phase"));
        this.setDefensiveMode(tag.func_74767_n("defensive"));
        this.setPhaseSwapping(tag.func_74767_n("swapping"));
        this.summonCooldown = tag.func_74762_e("summonCooldown");
        this.diveCooldown = tag.func_74762_e("diveCooldown");
        this.spikeCooldown = tag.func_74762_e("spikeCooldown");
        this.ramCooldown = tag.func_74762_e("ramCooldown");
        this.rageTimer = tag.func_74762_e("rage");
    }

    public boolean func_70039_c(CompoundNBT tag) {
        tag.func_74757_a("spikes", this.hasSpikes());
        tag.func_74757_a("horns", this.hasHorns());
        tag.func_74757_a("wings", this.hasWings());
        tag.func_74768_a("phase", this.getPhase());
        tag.func_74757_a("defensive", this.isDefensive());
        tag.func_74768_a("summonCooldown", this.summonCooldown);
        tag.func_74768_a("diveCooldown", this.diveCooldown);
        tag.func_74768_a("spikeCooldown", this.spikeCooldown);
        tag.func_74768_a("ramCooldown", this.ramCooldown);
        tag.func_74757_a("swapping", this.getPhaseSwapping());
        tag.func_74768_a("rage", this.rageTimer);
        return super.func_70039_c(tag);
    }

    @Override
    public void startAnimation(int arg) {
        try {
            AnimationController controller;
            if (arg == Animations.ATTACK.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("claw_swipe")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("claw_swipe", Boolean.valueOf(false)).addAnimation("idle"));
            }
            if (arg == Animations.HOWL.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                if (controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animationName.equals("howl")) {
                    return;
                }
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("howl", Boolean.valueOf(false)).addAnimation("idle"));
            }
            if (arg == Animations.CHARGE.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("ready_charge", Boolean.valueOf(false)).addAnimation("charge", Boolean.valueOf(true)));
            }
            if (arg == Animations.FLYING.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("flying", Boolean.valueOf(true)));
            }
            if (arg == Animations.DIVE_BOMB.ordinal()) {
                controller = (AnimationController)this.factory.getOrCreateAnimationData(Integer.valueOf(this.hashCode())).getAnimationControllers().get("attackController");
                controller.markNeedsReload();
                controller.setAnimation(new AnimationBuilder().addAnimation("divebomb", Boolean.valueOf(true)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        super.func_184231_a(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        if (this.hasWings()) {
            this.field_70143_R = 0.0f;
        }
        this.field_70143_R = Math.min(this.field_70143_R, 10.0f);
    }

    public PathNavigator func_70661_as() {
        return this.isFlying() ? this.flyingNavigator : super.func_70661_as();
    }

    public void initFlyingNavigator() {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, this.field_70170_p);
        flyingpathnavigator.func_192879_a(true);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        this.flyingNavigator = flyingpathnavigator;
    }

    public static void faceBlock(BlockPos block, LivingEntity citizen) {
        double xDifference = block.func_177958_n() - citizen.func_233580_cy_().func_177958_n();
        double zDifference = block.func_177952_p() - citizen.func_233580_cy_().func_177952_p();
        double yDifference = (float)block.func_177956_o() - ((float)citizen.func_233580_cy_().func_177956_o() + citizen.func_70047_e());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.field_70177_z = (float)(EntityChimera.updateRotation(citizen.field_70177_z, intendedRotationYaw, 360.0) % 360.0);
        citizen.field_70125_A = (float)(EntityChimera.updateRotation(citizen.field_70125_A, intendedRotationPitch, 360.0) % 360.0);
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = MathHelper.func_76138_g((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute getModdedAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 225.0).func_233815_a_(Attributes.field_233821_d_, 0.28).func_233815_a_(Attributes.field_233820_c_, (double)0.6f).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233826_i_, 6.0).func_233815_a_(Attributes.field_233819_b_, 100.0).func_233815_a_(Attributes.field_233822_e_, (double)0.4f);
    }

    public static class ChimeraMoveController
    extends MovementController {
        private final int maxTurn;
        private final boolean hoversInPlace;

        public ChimeraMoveController(EntityChimera p_i225710_1_, int maxTurn, boolean hoversInPlace) {
            super((MobEntity)p_i225710_1_);
            this.maxTurn = maxTurn;
            this.hoversInPlace = hoversInPlace;
        }

        public void func_75641_c() {
            EntityChimera chimera = (EntityChimera)this.field_75648_a;
            if (chimera.isFlying()) {
                if (chimera.diving) {
                    this.diveTick();
                } else {
                    this.flyTick();
                }
            } else {
                super.func_75641_c();
            }
        }

        public void flyTick() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                this.field_75648_a.func_189654_d(true);
                double d0 = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double d1 = this.field_75647_c - this.field_75648_a.func_226278_cu_();
                double d2 = this.field_75644_d - this.field_75648_a.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 90.0f);
                float f1 = this.field_75648_a.func_233570_aj_() ? (float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)) : (float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233822_e_));
                this.field_75648_a.func_70659_e(f1);
                double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f2 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d4) * 57.2957763671875));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, this.maxTurn);
                this.field_75648_a.func_70657_f(d1 > 0.0 ? f1 : -f1);
            } else {
                if (!this.hoversInPlace) {
                    this.field_75648_a.func_189654_d(false);
                }
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            }
        }

        public void diveTick() {
            EntityChimera mob = (EntityChimera)this.field_75648_a;
            double posX = mob.func_226277_ct_();
            double posY = mob.func_226278_cu_();
            double posZ = mob.func_226281_cx_();
            double motionX = mob.func_213322_ci().field_72450_a;
            double motionY = mob.func_213322_ci().field_72448_b;
            double motionZ = mob.func_213322_ci().field_72449_c;
            BlockPos dest = new BlockPos(mob.orbitOffset);
            double speedMod = 1.3;
            if (dest.func_177958_n() != 0 || dest.func_177956_o() != 0 || dest.func_177952_p() != 0) {
                double targetX = (double)dest.func_177958_n() + 0.5;
                double targetY = (double)dest.func_177956_o() + 0.5;
                double targetZ = (double)dest.func_177952_p() + 0.5;
                Vector3d targetVector = new Vector3d(targetX - posX, targetY - posY, targetZ - posZ);
                double length = targetVector.func_72433_c();
                targetVector = targetVector.func_186678_a(0.3 / length);
                double weight = 0.0;
                if (length <= 3.0) {
                    weight = 0.9 * ((3.0 - length) / 3.0);
                }
                motionX = (0.9 - weight) * motionX + (speedMod + weight) * targetVector.field_72450_a;
                motionY = (0.9 - weight) * motionY + (speedMod + weight) * targetVector.field_72448_b;
                motionZ = (0.9 - weight) * motionZ + (speedMod + weight) * targetVector.field_72449_c;
            }
            mob.func_213293_j(motionX, motionY, motionZ);
            EntityChimera.faceBlock(new BlockPos(mob.orbitOffset), (LivingEntity)mob);
        }
    }

    public static enum Animations {
        ATTACK,
        HOWL,
        CHARGE,
        FLYING,
        DIVE_BOMB;

    }
}

