/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import com.hollingsworth.arsnouveau.api.IFollowingSummon;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class FollowSummonerGoal
extends Goal {
    protected final IFollowingSummon summon;
    protected final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;

    public FollowSummonerGoal(IFollowingSummon mobEntity, LivingEntity owner, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.summon = mobEntity;
        this.world = mobEntity.getWorld();
        this.followSpeed = followSpeedIn;
        this.navigator = mobEntity.getPathNav();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(mobEntity.getPathNav() instanceof GroundPathNavigator) && !(mobEntity.getPathNav() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.summon.getSummoner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).func_175149_v()) {
            return false;
        }
        if (this.summon instanceof TameableEntity && ((TameableEntity)this.summon).func_233685_eM_()) {
            return false;
        }
        return !(this.summon.getSelfEntity().func_70068_e((Entity)livingentity) < (double)(this.minDist * this.minDist));
    }

    public boolean func_75253_b() {
        boolean flag = true;
        if (this.summon instanceof TameableEntity) {
            boolean bl = flag = !((TameableEntity)this.summon).func_233685_eM_();
        }
        if (this.summon.getSummoner() == null) {
            return false;
        }
        return !this.navigator.func_75500_f() && this.summon.getSelfEntity().func_70068_e((Entity)this.summon.getSummoner()) > (double)(this.maxDist * this.maxDist) && flag;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.summon.getSelfEntity().func_184643_a(PathNodeType.WATER);
        this.summon.getSelfEntity().func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.navigator.func_75499_g();
        this.summon.getSelfEntity().func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.summon.getSummoner() == null) {
            return;
        }
        this.summon.getSelfEntity().func_70671_ap().func_75651_a((Entity)this.summon.getSummoner(), 10.0f, (float)this.summon.getSelfEntity().func_70646_bf());
        if (this.summon instanceof TameableEntity && ((TameableEntity)this.summon).func_233685_eM_()) {
            return;
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.navigator.func_75497_a((Entity)this.summon.getSummoner(), this.followSpeed) && !(this.summon.getSelfEntity().func_70068_e((Entity)this.summon.getSummoner()) < 144.0)) {
                int i = MathHelper.func_76128_c((double)this.summon.getSummoner().func_226277_ct_()) - 2;
                int j = MathHelper.func_76128_c((double)this.summon.getSummoner().func_226281_cx_()) - 2;
                int k = MathHelper.func_76128_c((double)this.summon.getSummoner().func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.canTeleportToBlock(new BlockPos(i + l, k - 1, j + i1))) continue;
                        this.summon.getSelfEntity().func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.summon.getSelfEntity().field_70177_z, this.summon.getSelfEntity().field_70125_A);
                        this.navigator.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(BlockPos pos) {
        BlockState blockstate = this.world.func_180495_p(pos);
        return blockstate.func_215688_a((IBlockReader)this.world, pos, this.summon.getSelfEntity().func_200600_R()) && this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177981_b(2));
    }
}

