/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.goal.CheckStuckGoal;
import com.hollingsworth.arsnouveau.common.util.ArrayUtil;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class GetUnstuckGoal
extends CheckStuckGoal {
    int numUnstucks;
    BlockPos targetPos;
    public Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
    Supplier<Boolean> isStuck;
    MobEntity entity;
    boolean isStuckTrying;
    Function<Boolean, Void> setUnstuck;

    public GetUnstuckGoal(MobEntity entity, Supplier<Boolean> isStuck, Function<Boolean, Void> setUnstuck) {
        super(() -> ((MobEntity)entity).func_233580_cy_(), 4, null);
        this.entity = entity;
        this.isStuck = isStuck;
        this.setStuck = this::setStuckTrying;
        this.setUnstuck = setUnstuck;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public Void setStuckTrying(boolean isStuck) {
        this.isStuckTrying = isStuck;
        return null;
    }

    @Override
    public void func_75249_e() {
        this.resetStuckCheck();
        ArrayUtil.shuffleArray(this.directions);
        this.numUnstucks = 0;
        this.targetPos = this.getNextTarget();
        this.isStuckTrying = false;
        this.entity.func_70661_as().func_75499_g();
    }

    public boolean func_75253_b() {
        return this.targetPos != null && this.isStuck.get() != false;
    }

    public boolean func_75250_a() {
        return this.isStuck.get();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetPos == null) {
            return;
        }
        if (!(BlockUtil.distanceFrom(this.entity.func_233580_cy_(), this.targetPos) > 0.5)) {
            this.setUnstuck.apply(false);
            this.targetPos = null;
            return;
        }
        this.entity.func_70661_as().func_75484_a(this.getPath(this.targetPos), 1.2);
        if (this.isStuckTrying) {
            this.targetPos = this.getNextTarget();
            this.resetStuckCheck();
        }
    }

    public BlockPos getNextTarget() {
        ++this.numUnstucks;
        if (this.numUnstucks >= this.directions.length) {
            return null;
        }
        Direction direction = this.directions[this.numUnstucks];
        if (this.entity.func_184172_bi() == direction) {
            return this.getNextTarget();
        }
        for (int i = 3; i > 1; --i) {
            BlockPos posToMove = this.entity.func_233580_cy_().func_177967_a(direction, i);
            Path path = this.getPath(posToMove);
            if (path != null && path.func_224771_h()) {
                return posToMove;
            }
            if (this.getPath(posToMove.func_177977_b()) != null && this.getPath(posToMove.func_177977_b()).func_224771_h()) {
                return posToMove.func_177977_b();
            }
            if (this.getPath(posToMove.func_177979_c(2)) != null && this.getPath(posToMove.func_177979_c(2)).func_224771_h()) {
                return posToMove.func_177979_c(2);
            }
            if (this.getPath(posToMove.func_177984_a()) != null && this.getPath(posToMove.func_177984_a()).func_224771_h()) {
                return posToMove.func_177984_a();
            }
            if (this.getPath(posToMove.func_177981_b(2)) == null || !this.getPath(posToMove.func_177981_b(2)).func_224771_h()) continue;
            return posToMove.func_177981_b(2);
        }
        return this.getNextTarget();
    }

    public Path getPath(BlockPos p) {
        return this.entity.func_70661_as().func_179680_a(p, 0);
    }
}

