/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityCarbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TakeItemGoal
extends ExtendedRangeGoal {
    EntityCarbuncle carbuncle;
    BlockPos takePos;
    boolean unreachable;

    public TakeItemGoal(EntityCarbuncle carbuncle) {
        super(15);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.carbuncle = carbuncle;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.takePos = null;
        this.unreachable = false;
        this.startDistance = 0.0;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.takePos = this.carbuncle.getValidTakePos();
        this.unreachable = false;
        if (this.carbuncle.isTamed() && this.takePos != null && this.carbuncle.getHeldStack().func_190926_b()) {
            this.startDistance = BlockUtil.distanceFrom(this.carbuncle.field_233557_ao_, this.takePos);
            this.setPath(this.takePos.func_177958_n(), this.takePos.func_177956_o(), this.takePos.func_177952_p(), 1.2);
        }
    }

    public void getItem() {
        World world = this.carbuncle.field_70170_p;
        if (world.func_175625_s(this.takePos) == null) {
            return;
        }
        IItemHandler iItemHandler = (IItemHandler)world.func_175625_s(this.takePos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (iItemHandler == null) {
            return;
        }
        for (int j = 0; j < iItemHandler.getSlots(); ++j) {
            if (iItemHandler.getStackInSlot(j).func_190926_b() || !this.carbuncle.isValidItem(iItemHandler.getStackInSlot(j))) continue;
            this.carbuncle.setHeldStack(iItemHandler.extractItem(j, 64, false));
            this.carbuncle.field_70170_p.func_184148_a(null, this.carbuncle.func_226277_ct_(), this.carbuncle.func_226278_cu_(), this.carbuncle.func_226281_cx_(), SoundEvents.field_187638_cR, this.carbuncle.func_184176_by(), 1.0f, 1.0f);
            if (!(world instanceof ServerWorld)) break;
            OpenChestEvent event = new OpenChestEvent(FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)), this.takePos, 20);
            event.open();
            EventQueue.getServerInstance().addEvent(event);
            break;
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        Path path = this.carbuncle.func_70661_as().func_225466_a(x + 0.5, y + 1.0, z + 0.5, 1);
        if (path == null || !path.func_224771_h()) {
            this.unreachable = true;
        }
        this.carbuncle.func_70661_as().func_75484_a(path, speedIn);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.carbuncle.getHeldStack().func_190926_b() && this.takePos != null && BlockUtil.distanceFrom(this.carbuncle.func_213303_ch(), this.takePos) <= 2.0 + this.extendedRange) {
            World world = this.carbuncle.field_70170_p;
            TileEntity tileEntity = world.func_175625_s(this.takePos);
            if (tileEntity == null) {
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                this.getItem();
                return;
            }
        }
        if (this.takePos != null && this.carbuncle.getHeldStack().func_190926_b()) {
            this.setPath(this.takePos.func_177958_n(), this.takePos.func_177956_o(), this.takePos.func_177952_p(), 1.2);
            super.func_75246_d();
        }
    }

    public boolean func_75253_b() {
        return !this.unreachable && !this.carbuncle.isStuck && this.carbuncle.getHeldStack() != null && this.carbuncle.getHeldStack().func_190926_b() && this.carbuncle.backOff == 0 && this.carbuncle.isTamed() && this.takePos != null;
    }

    @Override
    public boolean func_75250_a() {
        return !this.carbuncle.isStuck && this.carbuncle.getHeldStack() != null && this.carbuncle.getHeldStack().func_190926_b() && this.carbuncle.backOff == 0 && this.carbuncle.isTamed();
    }
}

