/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;

public class ChimeraAttackGoal
extends Goal {
    protected final EntityChimera mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    public int timeAnimating = 0;
    public boolean arrived = false;
    public boolean done = false;

    public ChimeraAttackGoal(EntityChimera p_i1636_1_, boolean p_i1636_4_) {
        this.mob = p_i1636_1_;
        this.speedModifier = 1.8f;
        this.followingTargetEvenIfNotSeen = p_i1636_4_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_220685_C_() {
        return true;
    }

    public boolean func_75250_a() {
        long i = this.mob.field_70170_p.func_82737_E();
        if (!this.mob.canAttack()) {
            return false;
        }
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.func_70638_az();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.func_70661_as().func_75494_a((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.mob.func_70638_az();
        if (!this.mob.canAttack()) {
            return false;
        }
        if (livingentity == null || this.done) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.func_70661_as().func_75500_f();
        }
        if (!this.mob.func_213389_a(livingentity.func_233580_cy_())) {
            return false;
        }
        return !(livingentity instanceof PlayerEntity) || !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
    }

    public void func_75249_e() {
        this.mob.func_70661_as().func_75484_a(this.path, this.speedModifier);
        this.mob.func_213395_q(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.timeAnimating = 0;
        this.arrived = false;
        this.done = false;
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.mob.func_70638_az();
        this.mob.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
        if (this.arrived) {
            ++this.timeAnimating;
            if (this.timeAnimating == 15) {
                this.attack(livingentity);
            }
            if (this.timeAnimating >= 20) {
                this.attack(livingentity);
                this.done = true;
            }
            return;
        }
        double d0 = this.mob.func_70092_e(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (BlockUtil.distanceFrom(this.mob.field_233557_ao_, livingentity.field_233557_ao_) <= 3.0) {
            this.arrived = true;
            Networking.sendToNearby(this.mob.field_70170_p, (Entity)this.mob, (Object)new PacketAnimEntity(this.mob.func_145782_y(), EntityChimera.Animations.ATTACK.ordinal()));
        }
        if ((this.followingTargetEvenIfNotSeen || this.mob.func_70635_at().func_75522_a((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.func_70092_e(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.func_70681_au().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.func_226277_ct_();
            this.pathedTargetY = livingentity.func_226278_cu_();
            this.pathedTargetZ = livingentity.func_226281_cx_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.mob.func_70661_as().func_75505_d().func_75870_c()) != null && livingentity.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.func_70661_as().func_75497_a((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void attack(LivingEntity target) {
        double d0 = 3.0;
        if (BlockUtil.distanceFrom(target.field_233557_ao_, this.mob.field_233557_ao_) <= d0) {
            this.ticksUntilNextAttack = 20;
            this.mob.func_70652_k((Entity)target);
        }
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.func_213311_cf() * 2.0f * this.mob.func_213311_cf() * 2.0f + p_179512_1_.func_213311_cf();
    }
}

