/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.sylph;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;

public class FollowPlayerGoal
extends Goal {
    private final MobEntity entity;
    private final Predicate<PlayerEntity> followPredicate;
    private PlayerEntity followingEntity;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;
    private final float areaSize;
    private final float probability;

    public FollowPlayerGoal(MobEntity mob, double speedModifier, float stopDistance, float areaSize, float probability) {
        this.entity = mob;
        this.followPredicate = Objects::nonNull;
        this.speedModifier = speedModifier;
        this.navigation = mob.func_70661_as();
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.probability = probability;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(mob.func_70661_as() instanceof GroundPathNavigator) && !(mob.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    public FollowPlayerGoal(MobEntity mob, double speedModifier, float stopDistance, float areaSize) {
        this(mob, speedModifier, stopDistance, areaSize, 0.001f);
    }

    public boolean func_75250_a() {
        List list = this.entity.field_70170_p.func_175647_a(PlayerEntity.class, this.entity.func_174813_aQ().func_186662_g((double)this.areaSize), this.followPredicate);
        if (!list.isEmpty()) {
            for (PlayerEntity mobentity : list) {
                if (mobentity.func_82150_aj()) continue;
                this.followingEntity = mobentity;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.followingEntity != null && !this.navigation.func_75500_f() && this.entity.func_70068_e((Entity)this.followingEntity) > (double)(this.stopDistance * this.stopDistance);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.followingEntity = null;
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (this.followingEntity != null && !this.entity.func_110167_bD()) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.followingEntity, 10.0f, (float)this.entity.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.timeToRecalcPath = 10;
                double d0 = this.entity.func_226277_ct_() - this.followingEntity.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.entity.func_226278_cu_() - this.followingEntity.func_226278_cu_()) * d1 + (d2 = this.entity.func_226281_cx_() - this.followingEntity.func_226281_cx_()) * d2;
                if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                    this.navigation.func_75497_a((Entity)this.followingEntity, this.speedModifier);
                } else {
                    this.navigation.func_75499_g();
                    if (d3 <= (double)this.stopDistance) {
                        double d4 = this.followingEntity.func_226277_ct_() - this.entity.func_226277_ct_();
                        double d5 = this.followingEntity.func_226281_cx_() - this.entity.func_226281_cx_();
                        this.navigation.func_75492_a(this.entity.func_226277_ct_() - d4, this.entity.func_226278_cu_(), this.entity.func_226281_cx_() - d5, this.speedModifier);
                    }
                }
            }
        }
    }
}

