/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellBowRenderer;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SpellBow
extends BowItem
implements IAnimatable,
ICasterTool {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SpellBow() {
        super(ItemsRegistry.defaultItemProperties().func_200917_a(1).setISTER(() -> SpellBowRenderer::new));
    }

    public boolean canPlayerCastSpell(ItemStack bow, PlayerEntity playerentity) {
        ISpellCaster caster = this.getSpellCaster(bow);
        return new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).withSilent(true).canCast((LivingEntity)playerentity);
    }

    public ItemStack findAmmo(PlayerEntity playerEntity, ItemStack shootable) {
        if (!(shootable.func_77973_b() instanceof ShootableItem)) {
            return ItemStack.field_190927_a;
        }
        Predicate<ItemStack> predicate = ((ShootableItem)shootable.func_77973_b()).func_220006_d().and(i -> !(i.func_77973_b() instanceof SpellArrow) || i.func_77973_b() instanceof SpellArrow && this.canPlayerCastSpell(shootable, playerEntity));
        ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)playerEntity, predicate);
        if (!itemstack.func_190926_b()) {
            return itemstack;
        }
        predicate = ((ShootableItem)shootable.func_77973_b()).func_220004_b().and(i -> !(i.func_77973_b() instanceof SpellArrow) || i.func_77973_b() instanceof SpellArrow && this.canPlayerCastSpell(shootable, playerEntity));
        for (int i2 = 0; i2 < playerEntity.field_71071_by.func_70302_i_(); ++i2) {
            ItemStack itemstack1 = playerEntity.field_71071_by.func_70301_a(i2);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return playerEntity.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)Items.field_151032_g) : ItemStack.field_190927_a;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ISpellCaster caster = this.getSpellCaster(playerIn.func_184586_b(handIn));
        boolean hasAmmo = !this.findAmmo(playerIn, itemstack).func_190926_b();
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (PlayerEntity)playerIn, (Hand)handIn, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (hasAmmo || caster.getSpell() != null && new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerIn)).withSilent(true).canCast((LivingEntity)playerIn)) {
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !hasAmmo) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public EntitySpellArrow buildSpellArrow(World worldIn, PlayerEntity playerentity, ISpellCaster caster, boolean isSpellArrow) {
        EntitySpellArrow spellArrow = new EntitySpellArrow(worldIn, (LivingEntity)playerentity);
        spellArrow.spellResolver = new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity).withColors(caster.getColor())).withSilent(true);
        spellArrow.setColors(caster.getColor().r, caster.getColor().g, caster.getColor().b);
        if (isSpellArrow) {
            spellArrow.func_70239_b(0.0);
        }
        return spellArrow;
    }

    /*
     * WARNING - void declaration
     */
    public void func_77615_a(ItemStack bowStack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerentity = (PlayerEntity)entityLiving;
        boolean isInfinity = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bowStack) > 0;
        ItemStack arrowStack = this.findAmmo(playerentity, bowStack);
        int useTime = this.func_77626_a(bowStack) - timeLeft;
        if ((useTime = ForgeEventFactory.onArrowLoose((ItemStack)bowStack, (World)worldIn, (PlayerEntity)playerentity, (int)useTime, (!arrowStack.func_190926_b() || isInfinity ? 1 : 0) != 0)) < 0) {
            return;
        }
        boolean canFire = false;
        if (!arrowStack.func_190926_b() || isInfinity) {
            if (arrowStack.func_190926_b()) {
                arrowStack = new ItemStack((IItemProvider)Items.field_151032_g);
            }
            canFire = true;
        }
        ISpellCaster caster = this.getSpellCaster(bowStack);
        boolean isSpellArrow = false;
        if (arrowStack.func_190926_b() && caster.getSpell() != null && new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).canCast((LivingEntity)playerentity)) {
            canFire = true;
            isSpellArrow = true;
        }
        if (!canFire) {
            return;
        }
        float f = SpellBow.func_185059_b((int)useTime);
        if ((double)f >= 0.1 && canFire) {
            boolean isArrowInfinite;
            boolean bl = isArrowInfinite = playerentity.field_71075_bZ.field_75098_d || arrowStack.func_77973_b() instanceof ArrowItem && ((ArrowItem)arrowStack.func_77973_b()).isInfinite(arrowStack, bowStack, playerentity);
            if (!worldIn.field_72995_K) {
                ArrowItem arrowitem = (ArrowItem)(arrowStack.func_77973_b() instanceof ArrowItem ? arrowStack.func_77973_b() : Items.field_151032_g);
                Object abstractarrowentity = arrowitem.func_200887_a(worldIn, arrowStack, (LivingEntity)playerentity);
                abstractarrowentity = this.customArrow((AbstractArrowEntity)abstractarrowentity);
                ArrayList<Object> arrows = new ArrayList<Object>();
                boolean didCastSpell = false;
                if (arrowitem == Items.field_151032_g && caster.getSpell() != null && new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).withSilent(true).canCast((LivingEntity)playerentity)) {
                    abstractarrowentity = this.buildSpellArrow(worldIn, playerentity, caster, isSpellArrow);
                    new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).expendMana((LivingEntity)playerentity);
                    didCastSpell = true;
                } else if (arrowitem instanceof SpellArrow) {
                    if (caster.getSpell() == null || !new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).canCast((LivingEntity)playerentity)) {
                        return;
                    }
                    if (new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).canCast((LivingEntity)playerentity)) {
                        new SpellResolver(new SpellContext(caster.getSpell(), (LivingEntity)playerentity)).expendMana((LivingEntity)playerentity);
                        didCastSpell = true;
                    }
                }
                arrows.add(abstractarrowentity);
                if (caster.getSpell() != null && caster.getSpell().isValid() && didCastSpell) {
                    void var19_21;
                    int numSplits = caster.getSpell().getBuffsAtIndex(0, (LivingEntity)playerentity, AugmentSplit.class);
                    if (abstractarrowentity instanceof EntitySpellArrow) {
                        numSplits = ((EntitySpellArrow)((Object)abstractarrowentity)).spellResolver.spell.getBuffsAtIndex(0, (LivingEntity)playerentity, AugmentSplit.class);
                    }
                    boolean bl2 = true;
                    while (var19_21 < numSplits + 1) {
                        Direction offset = playerentity.func_174811_aO().func_176746_e();
                        if (var19_21 % 2 == false) {
                            offset = offset.func_176734_d();
                        }
                        BlockPos projPos = playerentity.func_233580_cy_().func_177967_a(offset, (int)var19_21);
                        projPos = projPos.func_177963_a(0.0, 1.5, 0.0);
                        EntitySpellArrow spellArrow = this.buildSpellArrow(worldIn, playerentity, caster, isSpellArrow);
                        spellArrow.func_70107_b(projPos.func_177958_n(), spellArrow.func_233580_cy_().func_177956_o(), projPos.func_177952_p());
                        arrows.add((Object)spellArrow);
                        ++var19_21;
                    }
                }
                for (AbstractArrowEntity abstractArrowEntity : arrows) {
                    abstractArrowEntity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (f >= 1.0f) {
                        abstractArrowEntity.func_70243_d(true);
                    }
                    this.addArrow(abstractArrowEntity, bowStack, arrowStack, isArrowInfinite, playerentity);
                }
            }
            worldIn.func_184148_a(null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!isArrowInfinite && !playerentity.field_71075_bZ.field_75098_d) {
                arrowStack.func_190918_g(1);
            }
        }
    }

    public void addArrow(AbstractArrowEntity abstractarrowentity, ItemStack bowStack, ItemStack arrowStack, boolean isArrowInfinite, PlayerEntity playerentity) {
        int punch;
        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bowStack);
        if (power > 0) {
            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if ((punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bowStack)) > 0) {
            abstractarrowentity.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bowStack) > 0) {
            abstractarrowentity.func_70015_d(100);
        }
        if (isArrowInfinite || playerentity.field_71075_bZ.field_75098_d && (arrowStack.func_77973_b() == Items.field_185166_h || arrowStack.func_77973_b() == Items.field_185167_i)) {
            abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        playerentity.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a.or(i -> i.func_77973_b() instanceof SpellArrow);
    }

    public void registerControllers(AnimationData data) {
    }

    public AbstractArrowEntity customArrow(AbstractArrowEntity arrow) {
        return super.customArrow(arrow);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip2, ITooltipFlag flagIn) {
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        super.func_77624_a(stack, worldIn, tooltip2, flagIn);
    }

    @Override
    public boolean isScribedSpellValid(ISpellCaster caster, PlayerEntity player, Hand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(PlayerEntity player) {
        PortUtil.sendMessageNoSpam((Entity)player, (ITextComponent)new TranslationTextComponent("ars_nouveau.bow.invalid"));
    }

    @Override
    public boolean setSpell(ISpellCaster caster, PlayerEntity player, Hand hand, ItemStack stack, Spell spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodProjectile.INSTANCE);
        recipe.addAll(spell.recipe);
        spell.recipe = recipe;
        return ICasterTool.super.setSpell(caster, player, hand, stack, spell);
    }

    public int func_77619_b() {
        return super.func_77619_b();
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }
}

