/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSummonFamiliar {
    String familiarID;
    int entityID;

    public PacketSummonFamiliar(String id, int entityID) {
        this.familiarID = id;
        this.entityID = entityID;
    }

    public PacketSummonFamiliar(PacketBuffer buf) {
        this.familiarID = buf.func_150789_c(Short.MAX_VALUE);
        this.entityID = buf.readInt();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.familiarID);
        buf.writeInt(this.entityID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() != null) {
                AbstractFamiliarHolder familiarHolder = ArsNouveauAPI.getInstance().getFamiliarHolderMap().get(this.familiarID);
                Entity owner = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73045_a(this.entityID);
                if (owner instanceof LivingEntity && ((LivingEntity)owner).func_70644_a(ModPotions.FAMILIAR_SICKNESS_EFFECT)) {
                    PortUtil.sendMessage(owner, (ITextComponent)new TranslationTextComponent("ars_nouveau.familiar.sickness"));
                    return;
                }
                for (Entity e : ((ServerWorld)owner.field_70170_p).func_241136_z_()) {
                    if (!(e instanceof IFamiliar)) continue;
                    ((IFamiliar)e).onFamiliarSpawned(owner.func_110124_au());
                }
                IFamiliar familiarEntity = familiarHolder.getSummonEntity(owner.field_70170_p);
                familiarEntity.setOwnerID(owner.func_110124_au());
                familiarEntity.getThisEntity().func_70107_b(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_());
                owner.field_70170_p.func_217376_c(familiarEntity.getThisEntity());
                ParticleUtil.spawnPoof((ServerWorld)owner.field_70170_p, familiarEntity.getThisEntity().func_233580_cy_());
                if (owner instanceof LivingEntity) {
                    ((LivingEntity)owner).func_195064_c(new EffectInstance(ModPotions.FAMILIAR_SICKNESS_EFFECT, 6000, 0, false, false, true));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

