/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.event.ChimeraSummonEvent;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTimedEvent {
    CompoundNBT tag;
    public static Map<String, Function<CompoundNBT, Void>> methodMap = new HashMap<String, Function<CompoundNBT, Void>>();

    public PacketTimedEvent(PacketBuffer buf) {
        this.tag = buf.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150786_a(this.tag);
    }

    public PacketTimedEvent(CompoundNBT tag) {
        this.tag = tag;
    }

    public PacketTimedEvent(ITimedEvent event) {
        this.tag = new CompoundNBT();
        event.serialize(this.tag);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!methodMap.containsKey(this.tag.func_74779_i("id"))) {
                throw new IllegalStateException("No event found for ID or ID missing");
            }
            methodMap.get(this.tag.func_74779_i("id")).apply(this.tag);
        });
        ctx.get().setPacketHandled(true);
    }

    static {
        methodMap.put("chimera", nbt -> ChimeraSummonEvent.get(nbt).onPacketHandled());
    }
}

