/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.world.server.ServerWorld;

public class RitualCloudshaper
extends AbstractRitual {
    @Override
    protected void tick() {
        ParticleUtil.spawnRitualSkyEffect(this, this.tile, this.rand, this.getCenterColor().toWrapper());
        if (this.getWorld().func_82737_E() % 20L == 0L && !this.getWorld().field_72995_K) {
            this.incrementProgress();
            if (this.getProgress() >= 18) {
                ServerWorld world = (ServerWorld)this.getWorld();
                if (!this.isStorm() && !this.isRain()) {
                    world.func_241113_a_(12000, 0, false, false);
                    this.setFinished();
                }
                if (this.isStorm()) {
                    world.func_241113_a_(0, 1200, true, true);
                    this.setFinished();
                }
                if (this.isRain()) {
                    world.func_241113_a_(0, 1200, true, false);
                    this.setFinished();
                }
            }
        }
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    public boolean isStorm() {
        return this.didConsumeItem(Items.field_221654_ao);
    }

    public boolean isRain() {
        return this.didConsumeItem(Items.field_151016_H);
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        return this.getConsumedItems().isEmpty() && (stack.func_77973_b() == Items.field_221654_ao || stack.func_77973_b() == Items.field_151016_H);
    }

    @Override
    public String getLangName() {
        return "Cloudshaping";
    }

    @Override
    public String getLangDescription() {
        return "This ritual can change the weather at a moments notice. By default, this ritual will set the weather to clear. Augmenting with Gunpowder will cause it to rain, while a Lapis Block will cause it to storm.";
    }

    @Override
    public String getID() {
        return "cloudshaping";
    }

    @Override
    public ParticleColor getCenterColor() {
        return !this.isRain() && !this.isStorm() ? new ParticleColor(this.rand.nextInt(255), this.rand.nextInt(255), this.rand.nextInt(255)) : new ParticleColor(this.rand.nextInt(100), this.rand.nextInt(100), this.rand.nextInt(255));
    }
}

