/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.event.FlightRefreshEvent;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RitualTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateFlight;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class RitualFlight
extends AbstractRitual {
    @Override
    protected void tick() {
        if (!this.getWorld().field_72995_K && this.getWorld().func_82737_E() % 20L == 0L) {
            RitualFlightHandler.activePositions.add(this.getPos());
        }
    }

    @Override
    public int getManaCost() {
        return 200;
    }

    @Override
    public String getID() {
        return "flight";
    }

    @Override
    public String getLangDescription() {
        return "Grants nearby players the Flight effect when they jump, allowing them to creatively fly for a short time. If the player is nearby, this ritual will refresh their flight buff. Each time this ritual grants or refreshes flight, it will expend source from nearby jars.";
    }

    @Override
    public String getLangName() {
        return "Flight";
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau")
    public static class RitualFlightHandler {
        public static Set<BlockPos> activePositions = new HashSet<BlockPos>();

        @Nullable
        public static RitualFlight getFlightRitual(World world, BlockPos pos) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof RitualTile && ((RitualTile)entity).ritual instanceof RitualFlight) {
                return (RitualFlight)((RitualTile)entity).ritual;
            }
            return null;
        }

        public static void grantFlight(LivingEntity entity) {
            BlockPos pos = RitualFlightHandler.getValidPosition(entity.field_70170_p, entity.func_233580_cy_());
            if (pos == null) {
                return;
            }
            TileEntity tileEntity = entity.field_70170_p.func_175625_s(pos);
            if (tileEntity instanceof RitualTile && ((RitualTile)tileEntity).ritual instanceof RitualFlight) {
                ((RitualTile)tileEntity).ritual.setNeedsMana(true);
                entity.func_195064_c(new EffectInstance((Effect)ModPotions.FLIGHT_EFFECT, 1800));
            }
        }

        public static BlockPos getValidPosition(World world, BlockPos fromPos) {
            ArrayList<BlockPos> stalePositions = new ArrayList<BlockPos>();
            BlockPos foundPos = null;
            for (BlockPos p : activePositions) {
                if (!(BlockUtil.distanceFrom(p, fromPos) <= 60.0)) continue;
                RitualFlight ritualFlight = RitualFlightHandler.getFlightRitual(world, p);
                if (ritualFlight == null) {
                    stalePositions.add(p);
                    continue;
                }
                if (ritualFlight.needsManaNow()) continue;
                foundPos = p;
                break;
            }
            activePositions.removeAll(stalePositions);
            return foundPos;
        }

        @Nullable
        public static BlockPos canPlayerStillFly(LivingEntity entity) {
            return RitualFlightHandler.getValidPosition(entity.field_70170_p, entity.func_233580_cy_());
        }

        @SubscribeEvent
        public static void refreshFlight(FlightRefreshEvent e) {
            if (!e.getEntityLiving().field_70170_p.field_72995_K) {
                BlockPos validPos = RitualFlightHandler.canPlayerStillFly(e.getEntityLiving());
                boolean wasFlying = e.getPlayer().field_71075_bZ.field_75100_b;
                if (validPos != null && wasFlying) {
                    e.getEntityLiving().func_195064_c(new EffectInstance((Effect)ModPotions.FLIGHT_EFFECT, 1200));
                    e.getPlayer().field_71075_bZ.field_75101_c = true;
                    e.getPlayer().field_71075_bZ.field_75100_b = wasFlying;
                    Networking.sendToPlayer(new PacketUpdateFlight(true, wasFlying), e.getPlayer());
                    TileEntity tile = e.getPlayer().field_70170_p.func_175625_s(validPos);
                    if (tile instanceof RitualTile && ((RitualTile)tile).ritual instanceof RitualFlight) {
                        ((RitualTile)tile).ritual.setNeedsMana(true);
                    }
                }
            }
        }
    }
}

