/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EffectBreak
extends AbstractEffect {
    public static EffectBreak INSTANCE = new EffectBreak();

    private EffectBreak() {
        super("break", "Break");
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    public ItemStack getStack(LivingEntity shooter) {
        if (this.isRealPlayer(shooter)) {
            ItemStack mainHand = this.getPlayer(shooter, (ServerWorld)shooter.field_70170_p).func_184614_ca();
            return (mainHand.func_190926_b() ? this.getPlayer(shooter, (ServerWorld)shooter.field_70170_p).func_184592_cb() : mainHand).func_77946_l();
        }
        return new ItemStack((IItemProvider)Items.field_151046_w);
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockPos pos = rayTraceResult.func_216350_a();
        int aoeBuff = spellStats.getBuffCount(AugmentAOE.INSTANCE);
        int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, pos, rayTraceResult, aoeBuff, pierceBuff);
        ItemStack stack = this.getStack(shooter);
        for (BlockPos pos1 : posList) {
            BlockState state = world.func_180495_p(pos1);
            if (!this.canBlockBeHarvested(spellStats, world, pos1) || !BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerWorld)world), world, pos1)) continue;
            if (spellStats.hasBuff(AugmentExtract.INSTANCE)) {
                stack.func_77966_a(Enchantments.field_185306_r, 1);
                state.func_177230_c().func_180657_a(world, this.getPlayer(shooter, (ServerWorld)world), pos1, world.func_180495_p(pos1), world.func_175625_s(pos1), stack);
                BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
                continue;
            }
            if (spellStats.hasBuff(AugmentFortune.INSTANCE)) {
                int bonus = spellStats.getBuffCount(AugmentFortune.INSTANCE);
                stack.func_77966_a(Enchantments.field_185308_t, bonus);
                state.func_177230_c().func_180637_b((ServerWorld)world, pos1, state.getExpDrop((IWorldReader)world, pos1, bonus, 0));
                state.func_177230_c().func_180657_a(world, this.getPlayer(shooter, (ServerWorld)world), pos1, world.func_180495_p(pos1), world.func_175625_s(pos1), stack);
                BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
                continue;
            }
            state.func_177230_c().func_180657_a(world, this.getPlayer(shooter, (ServerWorld)world), pos1, world.func_180495_p(pos1), world.func_175625_s(pos1), stack);
            BlockUtil.destroyBlockSafely(world, pos1, false, shooter);
            state.func_177230_c().func_180637_b((ServerWorld)world, pos1, state.getExpDrop((IWorldReader)world, pos1, 0, 0));
        }
    }

    @Override
    public boolean defaultedStarterGlyph() {
        return true;
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return rayTraceResult instanceof BlockRayTraceResult && world.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_185904_a() != Material.field_151579_a && this.canBlockBeHarvested(augments, world, ((BlockRayTraceResult)rayTraceResult).func_216350_a());
    }

    @Override
    public boolean dampenIsAllowed() {
        return true;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151035_b;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentPierce.INSTANCE, AugmentAOE.INSTANCE, AugmentExtract.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "A spell you start with. Breaks blocks of an average hardness. Can be amplified to increase the harvest level.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

