/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EffectDispel
extends AbstractEffect {
    public static EffectDispel INSTANCE = new EffectDispel();

    private EffectDispel() {
        super("dispel", "Dispel");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (rayTraceResult.func_216348_a() instanceof LivingEntity) {
            EffectInstance[] array;
            LivingEntity entity = (LivingEntity)rayTraceResult.func_216348_a();
            Collection effects = entity.func_70651_bq();
            for (EffectInstance e : array = effects.toArray(new EffectInstance[effects.size()])) {
                if (!e.isCurativeItem(new ItemStack((IItemProvider)Items.field_151117_aB))) continue;
                entity.func_195063_d(e.func_188419_a());
            }
            if (entity instanceof IDispellable && entity.func_70089_S() && entity.func_110143_aJ() > 0.0f && !entity.field_70128_L) {
                ((IDispellable)entity).onDispel(shooter);
            }
            MinecraftForge.EVENT_BUS.post((Event)new DispelEvent((RayTraceResult)rayTraceResult, world, shooter, spellStats.getAugments(), spellContext));
        }
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (world.func_180495_p(rayTraceResult.func_216350_a()) instanceof IDispellable) {
            ((IDispellable)world.func_180495_p(rayTraceResult.func_216350_a())).onDispel(shooter);
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return rayTraceResult instanceof EntityRayTraceResult || rayTraceResult instanceof BlockRayTraceResult && world.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_177230_c() instanceof IDispellable;
    }

    @Override
    public int getManaCost() {
        return 30;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151117_aB;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Removes any potion effects on the target. When used on a witch at half health, the witch will vanish in return for a Wixie shard. Will also dispel tamed summons back into their charm.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ABJURATION);
    }
}

