/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;

public class EffectFirework
extends AbstractEffect {
    public static FireworkRocketItem.Shape[] shapes = FireworkRocketItem.Shape.values();
    private static List<DyeColor> dyes;

    public EffectFirework() {
        super("firework", "Firework");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        if (!(rayTraceResult.func_216348_a() instanceof LivingEntity)) {
            return;
        }
        ItemStack firework = this.getCorrectFirework(spellContext, spellStats, shooter);
        for (int i = 0; i < spellStats.getBuffCount(AugmentSplit.INSTANCE) + 1; ++i) {
            this.spawnFireworkOnEntity(rayTraceResult, world, shooter, firework);
        }
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext);
        ItemStack firework = this.getCorrectFirework(spellContext, spellStats, shooter);
        for (int i = 0; i < spellStats.getBuffCount(AugmentSplit.INSTANCE) + 1; ++i) {
            this.spawnFireworkOnBlock(rayTraceResult, world, shooter, i, firework, spellContext);
        }
    }

    public ItemStack getCorrectFirework(SpellContext spellContext, SpellStats spellStats, LivingEntity shooter) {
        ItemStack firework = EffectFirework.getFirework((int)spellStats.getDurationMultiplier(), (int)spellStats.getAmpMultiplier());
        ItemStack foundStack = this.getItemFromCaster(shooter, spellContext, Items.field_196152_dE);
        return !foundStack.func_190926_b() ? foundStack : firework;
    }

    public void spawnFireworkOnBlock(BlockRayTraceResult rayTraceResult, World world, LivingEntity shooter, int i, ItemStack fireworkStack, SpellContext context) {
        FireworkRocketEntity fireworkrocketentity;
        if (context.getType() == SpellContext.CasterType.TURRET) {
            BlockPos pos = rayTraceResult.func_216350_a();
            Direction direction = rayTraceResult.func_216354_b().func_176734_d();
            fireworkrocketentity = new FireworkRocketEntity(world, fireworkStack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, true);
            fireworkrocketentity.func_70186_c((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e(), 0.5f, 1.0f);
        } else {
            BlockPos pos = rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b());
            fireworkrocketentity = new FireworkRocketEntity(world, (Entity)shooter, (double)pos.func_177958_n() + 0.5 + (double)i * ParticleUtil.inRange(-0.3, 0.3), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (double)i * ParticleUtil.inRange(-0.3, 0.3), fireworkStack);
        }
        world.func_217376_c((Entity)fireworkrocketentity);
    }

    public void spawnFireworkOnEntity(EntityRayTraceResult rayTraceResult, World world, LivingEntity shooter, ItemStack firework) {
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(world, firework, (LivingEntity)rayTraceResult.func_216348_a());
        fireworkrocketentity.func_212361_a((Entity)shooter);
        world.func_217376_c((Entity)fireworkrocketentity);
    }

    @Override
    public int getManaCost() {
        return 50;
    }

    @Override
    public String getBookDescription() {
        return "Creates a firework at the location or entity. Amplify will add Firework Stars, while Extend Time will add additional flight time. If a firework exists in the casters inventory, the created firework will mimic the held one. Spell Turrets with Touch will create fireworks as if they were dispensed.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_FIRE);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(AugmentExtendTime.INSTANCE, AugmentAmplify.INSTANCE, AugmentSplit.INSTANCE);
    }

    public static List<DyeColor> getColorfulDyes() {
        if (dyes == null) {
            dyes = Arrays.stream(DyeColor.values()).filter(d -> d != DyeColor.BLACK && d != DyeColor.GRAY && d != DyeColor.LIGHT_GRAY && d != DyeColor.BROWN).collect(Collectors.toList());
        }
        return dyes;
    }

    public static ItemStack getFirework(int numGunpowder, int numStars) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
        CompoundNBT rocketTag = stack.func_190925_c("Fireworks");
        rocketTag.func_74774_a("Flight", (byte)numGunpowder);
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < numStars; ++i) {
            listnbt.add((Object)EffectFirework.getRandomStar().func_179543_a("Explosion"));
        }
        if (!listnbt.isEmpty()) {
            rocketTag.func_218657_a("Explosions", (INBT)listnbt);
        }
        return stack;
    }

    public static ItemStack getRandomStar() {
        ItemStack star = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT starTag = star.func_190925_c("Explosion");
        Random random = new Random();
        FireworkRocketItem.Shape fireworkrocketitem$shape = shapes[random.nextInt(shapes.length)];
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < random.nextInt(8); ++i) {
            list.add(EffectFirework.getColorfulDyes().get(random.nextInt(EffectFirework.getColorfulDyes().size())).func_196060_f());
        }
        starTag.func_74757_a("Flicker", random.nextBoolean());
        starTag.func_74757_a("Trail", random.nextBoolean());
        starTag.func_197646_b("Colors", (List)list);
        starTag.func_74774_a("Type", (byte)fireworkrocketitem$shape.func_196071_a());
        return star;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_196152_dE;
    }
}

