/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EffectHarvest
extends AbstractEffect {
    public static EffectHarvest INSTANCE = new EffectHarvest();

    private EffectHarvest() {
        super("harvest", "Harvest");
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult ray, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        for (BlockPos blockpos : SpellUtil.calcAOEBlocks(shooter, ray.func_216350_a(), ray, spellStats)) {
            CropsBlock cropsBlock;
            BlockState state = world.func_180495_p(blockpos);
            if (state.func_177230_c() instanceof FarmlandBlock || world.func_180495_p(blockpos.func_177984_a()).func_177230_c() instanceof CropsBlock) {
                blockpos = blockpos.func_177984_a();
                state = world.func_180495_p(blockpos);
            }
            if (!(state.func_177230_c() instanceof CropsBlock) || !(cropsBlock = (CropsBlock)world.func_180495_p(blockpos).func_177230_c()).func_185525_y(state) || !(world instanceof ServerWorld)) continue;
            List cropDrops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)blockpos, (TileEntity)world.func_175625_s(blockpos));
            if (spellStats.hasBuff(AugmentFortune.INSTANCE)) {
                cropDrops = state.func_215693_a(LootUtil.getFortuneContext((ServerWorld)world, blockpos, shooter, spellStats.getBuffCount(AugmentFortune.INSTANCE)));
            }
            BlockPos finalBlockpos = blockpos;
            cropDrops.forEach(d -> {
                if (d.func_77973_b() == BlockRegistry.MAGE_BLOOM_CROP.func_199767_j()) {
                    return;
                }
                world.func_217376_c((Entity)new ItemEntity(world, (double)finalBlockpos.func_177958_n(), (double)finalBlockpos.func_177956_o(), (double)finalBlockpos.func_177952_p(), d));
            });
            world.func_175656_a(blockpos, cropsBlock.func_185528_e(1));
        }
    }

    @Override
    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        if (!(rayTraceResult instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockPos pos = ((BlockRayTraceResult)rayTraceResult).func_216350_a();
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof FarmlandBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof CropsBlock) {
            pos = pos.func_177984_a();
            state = world.func_180495_p(pos);
        }
        if (!(state.func_177230_c() instanceof CropsBlock)) {
            return false;
        }
        CropsBlock cropsBlock = (CropsBlock)world.func_180495_p(pos).func_177230_c();
        return cropsBlock.func_185525_y(state) && world instanceof ServerWorld;
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_151019_K;
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentFortune.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "When used on grown crops, this spell will obtain the fully grown product without destroying the plant.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

