/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EffectToss
extends AbstractEffect {
    public EffectToss() {
        super("toss", "Toss");
    }

    @Override
    public void onResolveEntity(EntityRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        BlockPos pos = rayTraceResult.func_216348_a().func_233580_cy_();
        this.summonStack(shooter, spellContext, world, pos);
    }

    public void summonStack(LivingEntity shooter, SpellContext context, World world, BlockPos pos) {
        ItemStack stack = this.getItemFromCaster(shooter, context, (ItemStack i) -> {
            if (!i.func_190926_b() && shooter instanceof PlayerEntity) {
                return !ItemStack.func_77989_b((ItemStack)shooter.func_184614_ca(), (ItemStack)i);
            }
            return true;
        });
        world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack.func_77946_l()));
        stack.func_190920_e(0);
    }

    @Override
    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext);
        BlockPos pos = rayTraceResult.func_216350_a().func_177972_a(rayTraceResult.func_216354_b());
        if (world.func_175625_s(rayTraceResult.func_216350_a()) != null && world.func_175625_s(rayTraceResult.func_216350_a()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            TileEntity tileEntity = world.func_175625_s(rayTraceResult.func_216350_a());
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                this.getItemFromCaster(shooter, spellContext, (ItemStack i) -> {
                    if (i.func_190926_b()) {
                        return false;
                    }
                    if (shooter instanceof PlayerEntity && ItemStack.func_77989_b((ItemStack)shooter.func_184614_ca(), (ItemStack)i)) {
                        return false;
                    }
                    ItemStack orig = i.func_77946_l();
                    ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)orig, (boolean)false);
                    if (left.func_77969_a(orig)) {
                        return false;
                    }
                    i.func_190920_e(left.func_190916_E());
                    return true;
                });
            }
        } else {
            this.summonStack(shooter, spellContext, world, pos);
        }
    }

    @Override
    @Nullable
    public Item getCraftingReagent() {
        return Items.field_221874_eu;
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getManaCost() {
        return 10;
    }

    @Override
    public String getBookDescription() {
        return "Causes the caster to place an item from their inventory to a location. If this glyph is used on an inventory, the item will attempt to be inserted into it.";
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(new AbstractAugment[0]);
    }
}

