/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.artemislib.util;

import com.artemis.artemislib.capabilities.sizeCap.SizeCapPro;
import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AttachAttributes {
    @SubscribeEvent
    public void attachAttributes(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            AbstractAttributeMap map = entity.func_110140_aT();
            map.func_111150_b(ArtemisLibAttributes.ENTITY_HEIGHT);
            map.func_111150_b(ArtemisLibAttributes.ENTITY_WIDTH);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        player.getCapability(SizeCapPro.sizeCapability, null).ifPresent(cap -> {
            boolean hasHeightModifier = player.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111122_c().isEmpty();
            boolean hasWidthModifier = player.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111122_c().isEmpty();
            double heightAttribute = player.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111126_e();
            double widthAttribute = player.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111126_e();
            float height = (float)((double)cap.getDefaultHeight() * heightAttribute);
            float width = (float)((double)cap.getDefaultWidth() * widthAttribute);
            if (!hasHeightModifier || !hasWidthModifier) {
                if (!cap.getTrans()) {
                    cap.setDefaultHeight(1.8f);
                    cap.setDefaultWidth(0.6f);
                    cap.setTrans(true);
                }
                if (cap.getTrans()) {
                    float eyeHeight = (float)((double)player.getDefaultEyeHeight() * heightAttribute);
                    if (player.func_70093_af()) {
                        eyeHeight = (height *= (float)MathHelper.func_76123_f((float)0.9f)) * (float)MathHelper.func_76123_f((float)0.9f);
                    }
                    if (player.func_184613_cA()) {
                        height *= 0.33f;
                    }
                    if (player.func_70608_bn()) {
                        width = 0.2f;
                        height = 0.2f;
                    }
                    if (player.func_200601_bK()) {
                        // empty if block
                    }
                    eyeHeight = MathHelper.func_76131_a((float)eyeHeight, (float)0.22f, (float)eyeHeight);
                    width = MathHelper.func_76131_a((float)width, (float)0.26f, (float)width);
                    height = MathHelper.func_76131_a((float)height, (float)0.26f, (float)height);
                    if (player.func_70047_e() != eyeHeight) {
                        ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)Float.valueOf(eyeHeight), (String)"eyeHeight");
                    }
                    player.field_70131_O = height;
                    player.field_70130_N = width;
                    double d0 = (double)width / 2.0;
                    AxisAlignedBB aabb = player.func_174813_aQ();
                    player.func_174826_a(new AxisAlignedBB(player.field_70165_t - d0, aabb.field_72338_b, player.field_70161_v - d0, player.field_70165_t + d0, aabb.field_72338_b + (double)player.field_70131_O, player.field_70161_v + d0));
                }
            } else if (cap.getTrans()) {
                player.field_70131_O = height;
                player.field_70130_N = width;
                double d0 = (double)width / 2.0;
                AxisAlignedBB aabb = player.func_174813_aQ();
                player.func_174826_a(new AxisAlignedBB(player.field_70165_t - d0, aabb.field_72338_b, player.field_70161_v - d0, player.field_70165_t + d0, aabb.field_72338_b + (double)height, player.field_70161_v + d0));
                ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)Float.valueOf(player.getDefaultEyeHeight()), (String)"eyeHeight");
                cap.setTrans(false);
            }
        });
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer)) {
            entity.getCapability(SizeCapPro.sizeCapability, null).ifPresent(cap -> {
                boolean hasHeightModifier = entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111122_c().isEmpty();
                boolean hasWidthModifier = entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111122_c().isEmpty();
                double heightAttribute = entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111126_e();
                double widthAttribute = entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111126_e();
                float height = (float)((double)cap.getDefaultHeight() * heightAttribute);
                float width = (float)((double)cap.getDefaultWidth() * widthAttribute);
                if (!hasHeightModifier || !hasWidthModifier) {
                    if (!cap.getTrans()) {
                        cap.setDefaultHeight(entity.field_70131_O);
                        cap.setDefaultWidth(entity.field_70130_N);
                        cap.setTrans(true);
                    }
                    if (cap.getTrans()) {
                        entity.field_70131_O = height;
                        entity.field_70130_N = width;
                        double d0 = (double)width / 2.0;
                        AxisAlignedBB aabb = entity.func_174813_aQ();
                        entity.func_174826_a(new AxisAlignedBB(entity.field_70165_t - d0, aabb.field_72338_b, entity.field_70161_v - d0, entity.field_70165_t + d0, aabb.field_72338_b + (double)entity.field_70131_O, entity.field_70161_v + d0));
                    }
                } else if (cap.getTrans()) {
                    entity.field_70131_O = height;
                    entity.field_70130_N = width;
                    double d0 = (double)width / 2.0;
                    AxisAlignedBB aabb = entity.func_174813_aQ();
                    entity.func_174826_a(new AxisAlignedBB(entity.field_70165_t - d0, aabb.field_72338_b, entity.field_70161_v - d0, entity.field_70165_t + d0, aabb.field_72338_b + (double)height, entity.field_70161_v + d0));
                    cap.setTrans(false);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityRenderPre(RenderLivingEvent.Pre event) {
        EntityPlayer player;
        EntityLivingBase entity = event.getEntity();
        float height = (float)entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111126_e();
        float width = (float)entity.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_WIDTH).func_111126_e();
        float scaleHeight = MathHelper.func_76131_a((float)height, (float)0.01f, (float)height);
        float scaleWidth = MathHelper.func_76131_a((float)width, (float)0.01f, (float)width);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)scaleWidth, (double)scaleHeight, (double)scaleWidth);
        GlStateManager.func_179137_b((double)(event.getX() / (double)scaleWidth - event.getX()), (double)(event.getY() / (double)scaleHeight - event.getY()), (double)(event.getZ() / (double)scaleWidth - event.getZ()));
        if (!(entity instanceof EntityPlayer) || (player = (EntityPlayer)entity).func_184187_bx() instanceof AbstractHorse) {
            // empty if block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onLivingRenderPost(RenderLivingEvent.Post event) {
        GlStateManager.func_179121_F();
    }
}

