/*
 * Decompiled with CFR 0.152.
 */
package mods.autodropper.block;

import mods.autodropper.AutoDropper;
import mods.autodropper.tileentity.TileEntityAutoDropper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAutoDropper
extends BlockContainer {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");

    public BlockAutoDropper() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.5f);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.setRegistryName("auto_dropper");
        this.func_149663_c("autodropper.auto_dropper");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        AutoDropper.proxy.registerModel(Item.func_150898_a((Block)this), 0, new ModelResourceLocation("minecraft:dropper", "inventory"));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setDefaultDirection(world, pos, state);
        if (world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    private void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean fullBlockNorth = world.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean fullBlockSouth = world.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && fullBlockNorth && !fullBlockSouth) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && fullBlockSouth && !fullBlockNorth) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean fullBlockWest = world.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean fullBlockEast = world.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && fullBlockWest && !fullBlockEast) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && fullBlockEast && !fullBlockWest) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        if (!world.field_72995_K && (tileentity = world.func_175625_s(pos)) instanceof TileEntityAutoDropper) {
            player.func_71007_a((IInventory)((TileEntityAutoDropper)tileentity));
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean isPoweredByRedstone = world.func_175640_z(pos) || world.func_175640_z(fromPos.func_177984_a());
        boolean isPoweredByMeta = (Boolean)state.func_177229_b((IProperty)TRIGGERED);
        if (isPoweredByRedstone && !isPoweredByMeta) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isPoweredByRedstone && isPoweredByMeta) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAutoDropper();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityAutoDropper) {
            ((TileEntityAutoDropper)tileentity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityAutoDropper) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityAutoDropper)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public static IPosition getDispensePosition(IBlockSource coords) {
        EnumFacing enumfacing = (EnumFacing)coords.func_189992_e().func_177229_b((IProperty)FACING);
        double d0 = coords.func_82615_a() + 0.7 * (double)enumfacing.func_82601_c();
        double d1 = coords.func_82617_b() + 0.7 * (double)enumfacing.func_96559_d();
        double d2 = coords.func_82616_c() + 0.7 * (double)enumfacing.func_82599_e();
        return new PositionImpl(d0, d1, d2);
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockAutoDropper.getFacing(meta)).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }
}

