/*
 * Decompiled with CFR 0.152.
 */
package mods.autodropper.tileentity;

import mods.autodropper.block.BlockAutoDropper;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityAutoDropper
extends TileEntityDispenser
implements ITickable {
    private int ticksExpired = 0;
    private int ticksMax = 4;

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "tile.autodropper.auto_dropper.name";
    }

    public String func_174875_k() {
        return "minecraft:dropper";
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksExpired;
        if (this.ticksExpired < this.ticksMax) {
            return;
        }
        this.ticksExpired = 0;
        this.triggerDispense(this.func_145831_w(), this.field_174879_c);
    }

    protected void triggerDispense(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if ((this.func_145832_p() & 8) != 0) {
            return;
        }
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(world, pos);
        int slot = this.func_146017_i();
        if (slot >= 0) {
            ItemStack newstack;
            ItemStack slotstack = this.func_70301_a(slot);
            EnumFacing enumfacing = BlockAutoDropper.getFacing(this.func_145832_p());
            IInventory iinventory = TileEntityHopper.func_145893_b((World)world, (double)((double)x + (double)enumfacing.func_82601_c()), (double)((double)y + (double)enumfacing.func_96559_d()), (double)((double)z + (double)enumfacing.func_82599_e()));
            if (iinventory != null) {
                newstack = TileEntityHopper.func_174918_a((IInventory)this, (IInventory)iinventory, (ItemStack)slotstack.func_77946_l().func_77979_a(1), (EnumFacing)enumfacing.func_176734_d());
                if (newstack.func_190926_b()) {
                    newstack = slotstack.func_77946_l();
                    newstack.func_190918_g(1);
                } else {
                    newstack = slotstack.func_77946_l();
                }
            } else {
                newstack = this.dispenseStack((IBlockSource)blocksourceimpl, slotstack);
                blocksourceimpl.func_82618_k().func_175718_b(1000, pos, 0);
                blocksourceimpl.func_82618_k().func_175718_b(2000, pos, this.getFrontOffset(BlockAutoDropper.getFacing(this.func_145832_p())));
            }
            this.func_70299_a(slot, newstack);
        }
    }

    protected ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        EnumFacing enumfacing = BlockAutoDropper.getFacing(this.func_145832_p());
        IPosition iposition = BlockAutoDropper.getDispensePosition(source);
        ItemStack itemstack1 = stack.func_77979_a(1);
        TileEntityAutoDropper.doDispense(source.func_82618_k(), itemstack1, 6, enumfacing, iposition);
        return stack;
    }

    public static void doDispense(World world, ItemStack stack, int speed, EnumFacing facing, IPosition position) {
        double d0 = position.func_82615_a();
        double d1 = position.func_82617_b();
        double d2 = position.func_82616_c();
        if (facing == EnumFacing.DOWN) {
            EntityItem entityitem = new EntityItem(world, d0, d1 - 0.1, d2, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityitem);
        } else if (facing == EnumFacing.UP) {
            EntityItem entityitem = new EntityItem(world, d0, d1 + 0.05, d2, stack);
            entityitem.field_70159_w = (double)facing.func_82601_c() * 0.3;
            entityitem.field_70181_x = 0.10000000298023223;
            entityitem.field_70179_y = (double)facing.func_82599_e() * 0.3;
            world.func_72838_d((Entity)entityitem);
        } else {
            EntityItem entityitem = new EntityItem(world, d0, d1 - 0.1, d2, stack);
            entityitem.field_70159_w = (double)facing.func_82601_c() * 0.3;
            entityitem.field_70181_x = 0.2f;
            entityitem.field_70179_y = (double)facing.func_82599_e() * 0.3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    private int getFrontOffset(EnumFacing facing) {
        return facing.func_82601_c() + 1 + (facing.func_82599_e() + 1) * 3;
    }
}

