/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.config;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.config.ConfigBetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.skeleton_dungeon.SkeletonDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.small_dungeon.SmallDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.SpiderDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon.ZombieDungeonStructure;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="betterdungeons-fabric-1_17")
public class BDConfig
implements ConfigData {
    @ConfigEntry.Category(value="Better Dungeons")
    @ConfigEntry.Gui.TransitiveObject
    public ConfigBetterDungeons betterDungeons = new ConfigBetterDungeons();

    public void validatePostLoad() {
        SmallDungeonStructure.whitelistedDimensions = this.createDimensionWhitelist(this.betterDungeons.smallDungeon.whitelistedDimensions, SmallDungeonStructure.whitelistedDimensions);
        SpiderDungeonStructure.whitelistedDimensions = this.createDimensionWhitelist(this.betterDungeons.spiderDungeon.whitelistedDimensions, SpiderDungeonStructure.whitelistedDimensions);
        SkeletonDungeonStructure.whitelistedDimensions = this.createDimensionWhitelist(this.betterDungeons.skeletonDungeon.whitelistedDimensions, SkeletonDungeonStructure.whitelistedDimensions);
        ZombieDungeonStructure.whitelistedDimensions = this.createDimensionWhitelist(this.betterDungeons.zombieDungeon.whitelistedDimensions, ZombieDungeonStructure.whitelistedDimensions);
        SmallDungeonStructure.blacklistedBiomes = this.createBiomeBlacklist(this.betterDungeons.smallDungeon.blacklistedBiomes, SmallDungeonStructure.blacklistedBiomes);
        SpiderDungeonStructure.blacklistedBiomes = this.createBiomeBlacklist(this.betterDungeons.spiderDungeon.blacklistedBiomes, SpiderDungeonStructure.blacklistedBiomes);
        SkeletonDungeonStructure.blacklistedBiomes = this.createBiomeBlacklist(this.betterDungeons.skeletonDungeon.blacklistedBiomes, SkeletonDungeonStructure.blacklistedBiomes);
        ZombieDungeonStructure.blacklistedBiomes = this.createBiomeBlacklist(this.betterDungeons.zombieDungeon.blacklistedBiomes, ZombieDungeonStructure.blacklistedBiomes);
        int spacing = this.betterDungeons.smallDungeon.smallDungeonSeparationDistance;
        int separation = this.betterDungeons.smallDungeon.smallDungeonDistanceVariation;
        if (spacing < separation) {
            BetterDungeons.LOGGER.error("Small Dungeon Average Separation Distance cannot be less than Small Dungeon Separation Distance Variation!");
            BetterDungeons.LOGGER.error("Found: {} and {}", (Object)spacing, (Object)separation);
            BetterDungeons.LOGGER.error("Using default values instead...");
            this.betterDungeons.smallDungeon.smallDungeonSeparationDistance = 10;
            this.betterDungeons.smallDungeon.smallDungeonDistanceVariation = 6;
        }
    }

    private List<String> createDimensionWhitelist(String dimensionWhitelistString, List<String> defaultList) {
        int strLen = dimensionWhitelistString.length();
        if (strLen < 2 || dimensionWhitelistString.charAt(0) != '[' || dimensionWhitelistString.charAt(strLen - 1) != ']') {
            BetterDungeons.LOGGER.error("INVALID VALUE FOR SETTING 'Whitelisted Dimensions'. Using [minecraft:overworld] instead...");
            return defaultList;
        }
        return Lists.newArrayList((Object[])dimensionWhitelistString.substring(1, strLen - 1).split(",\\s*"));
    }

    private List<String> createBiomeBlacklist(String biomeBlacklistString, List<String> defaultList) {
        int strLen = biomeBlacklistString.length();
        if (strLen < 2 || biomeBlacklistString.charAt(0) != '[' || biomeBlacklistString.charAt(strLen - 1) != ']') {
            BetterDungeons.LOGGER.error("INVALID VALUE FOR SETTING 'Blacklisted Biomes'. Using default instead...");
            return defaultList;
        }
        return Lists.newArrayList((Object[])biomeBlacklistString.substring(1, strLen - 1).split(",\\s*"));
    }
}

