/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructurePieces;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.BitSet;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6130;

public class SpiderDungeonNestPiece
extends SpiderDungeonPiece {
    private final class_2338 startPos;
    private float xRadius = 0.0f;
    private float yRadius = 0.0f;
    private float zRadius = 0.0f;
    private static final float X_MINRADIUS = 6.0f;
    private static final float X_MAXRADIUS = 10.0f;
    private static final float Y_MINRADIUS = 4.0f;
    private static final float Y_MAXRADIUS = 6.0f;
    private static final float Z_MINRADIUS = 6.0f;
    private static final float Z_MAXRADIUS = 10.0f;
    private static final BlockSetSelector COBWEB_SELECTOR = BlockSetSelector.from((class_2680[])new class_2680[]{class_2246.field_10343.method_9564()});
    private static final BlockSetSelector WOOL_SELECTOR = BlockSetSelector.from((class_2680[])new class_2680[]{class_2246.field_10446.method_9564()});

    public SpiderDungeonNestPiece(class_2338 startPos, int pieceChainLength) {
        super(BDModStructurePieces.SPIDER_DUNGEON_NEST_PIECE, pieceChainLength, SpiderDungeonNestPiece.getInitialBlockBox(startPos));
        this.startPos = new class_2338(startPos.method_10263(), startPos.method_10264(), startPos.method_10260());
    }

    public SpiderDungeonNestPiece(class_3218 world, class_2487 compoundNBT) {
        super(BDModStructurePieces.SPIDER_DUNGEON_NEST_PIECE, compoundNBT);
        int[] start = compoundNBT.method_10561("startPos");
        this.startPos = new class_2338(start[0], start[1], start[2]);
        this.xRadius = compoundNBT.method_10583("xRadius");
        this.yRadius = compoundNBT.method_10583("yRadius");
        this.zRadius = compoundNBT.method_10583("zRadius");
    }

    protected void method_14943(class_3218 world, class_2487 nbt) {
        nbt.method_10539("startPos", new int[]{this.startPos.method_10263(), this.startPos.method_10264(), this.startPos.method_10260()});
        nbt.method_10548("xRadius", this.xRadius);
        nbt.method_10548("yRadius", this.yRadius);
        nbt.method_10548("zRadius", this.zRadius);
    }

    public void method_14918(class_3443 structurePiece, class_6130 structurePiecesHolder, Random random) {
        this.xRadius = random.nextFloat() * 4.0f + 6.0f;
        this.yRadius = random.nextFloat() * 2.0f + 4.0f;
        this.zRadius = random.nextFloat() * 4.0f + 6.0f;
        this.field_15315.field_14380 = this.startPos.method_10263() - (int)this.xRadius - 4;
        this.field_15315.field_14377 = this.startPos.method_10263() + (int)this.xRadius + 4;
        this.field_15315.field_14379 = this.startPos.method_10264() - (int)this.yRadius - 4;
        this.field_15315.field_14376 = this.startPos.method_10264() + (int)this.yRadius + 4;
        this.field_15315.field_14378 = this.startPos.method_10260() - (int)this.zRadius - 4;
        this.field_15315.field_14381 = this.startPos.method_10260() + (int)this.zRadius + 4;
    }

    public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 generator, Random random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2919 decoRand = new class_2919();
        decoRand.method_12664(world.method_8412(), this.startPos.method_10263(), this.startPos.method_10260());
        BitSet carvingMask = new BitSet(65536);
        BlockSetSelector shellSelector = new BlockSetSelector(class_2246.field_10445.method_9564());
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.method_10103(chunkPos.method_8326() + x, 1, chunkPos.method_8328() + z);
                surface[x * 16 + z] = world.method_8624(class_2902.class_2903.field_13194, mutable.method_10263(), mutable.method_10260());
            }
        }
        float caveStartX = this.startPos.method_10263();
        float caveStartY = this.startPos.method_10264();
        float caveStartZ = this.startPos.method_10260();
        int minX = class_3532.method_15375((float)(caveStartX - this.xRadius)) - chunkPos.field_9181 * 16 - 1;
        int maxX = class_3532.method_15375((float)(caveStartX + this.xRadius)) - chunkPos.field_9181 * 16 + 1;
        int minY = class_3532.method_15340((int)(class_3532.method_15375((float)(caveStartY - this.yRadius)) - 1), (int)0, (int)255);
        int maxY = class_3532.method_15340((int)(class_3532.method_15375((float)(caveStartY + this.yRadius)) + 1), (int)0, (int)255);
        int minZ = class_3532.method_15375((float)(caveStartZ - this.zRadius)) - chunkPos.field_9180 * 16 - 1;
        int maxZ = class_3532.method_15375((float)(caveStartZ + this.zRadius)) - chunkPos.field_9180 * 16 + 1;
        minX = class_3532.method_15340((int)minX, (int)0, (int)15);
        maxX = class_3532.method_15340((int)maxX, (int)0, (int)15);
        minZ = class_3532.method_15340((int)minZ, (int)0, (int)15);
        maxZ = class_3532.method_15340((int)maxZ, (int)0, (int)15);
        for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
            int globalX = (int)x + chunkPos.field_9181 * 16;
            if (globalX < chunkPos.method_8326() || globalX > chunkPos.method_8327()) continue;
            float radialXDist = ((float)globalX - caveStartX + 0.5f) / this.xRadius;
            for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                int globalY;
                int globalZ = (int)z + chunkPos.field_9180 * 16;
                if (globalZ < chunkPos.method_8328() || globalZ > chunkPos.method_8329()) continue;
                float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / this.zRadius;
                for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                    class_2680 state;
                    float radialYDist = (y - caveStartY - 0.5f) / this.yRadius;
                    int mask = (int)x | (int)z << 4 | (int)y << 8;
                    float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                    if ((double)radialDist < 1.0) {
                        if ((float)globalX == caveStartX && (float)globalZ == caveStartZ && (float)globalY > caveStartY) {
                            this.method_14917(world, class_2246.field_10446.method_9564(), globalX, globalY, globalZ, box);
                            continue;
                        }
                        if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains(this.method_14929((class_1922)world, globalX, globalY, globalZ, box).method_26204())) continue;
                        this.method_14917(world, class_2246.field_10543.method_9564(), globalX, globalY, globalZ, box);
                        carvingMask.set(mask);
                        continue;
                    }
                    float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (this.xRadius + 1.2f);
                    float radialYDistShell = (y - caveStartY - 0.5f) / (this.yRadius + 1.2f);
                    float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (this.zRadius + 1.2f);
                    float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                    if (!((double)radialDistShell < 1.0)) continue;
                    if ((float)globalX == caveStartX && (float)globalZ == caveStartZ && (float)globalY > caveStartY) {
                        this.method_14917(world, class_2246.field_10446.method_9564(), globalX, globalY, globalZ, box);
                        continue;
                    }
                    if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains((state = this.method_14929((class_1922)world, globalX, globalY, globalZ, box)).method_26204()) || state.method_26207() == class_3614.field_15959 || state.method_26227().method_15772() == class_3612.field_15906 && !(decoRand.nextFloat() < 0.8f)) continue;
                    this.method_14917(world, shellSelector.get((Random)decoRand), globalX, globalY, globalZ, box);
                }
            }
        }
        this.placeSphereRandomized(world, box, (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, 2.0f, (Random)decoRand, 0.5f, WOOL_SELECTOR, true);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX + 1, (int)caveStartY + 1, (int)caveStartZ, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX - 1, (int)caveStartY + 1, (int)caveStartZ, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ + 1, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ - 1, box);
        this.method_14917(world, class_2246.field_10446.method_9564(), (int)caveStartX, (int)caveStartY, (int)caveStartZ, box);
        this.placeSphereRandomized(world, box, (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, 3.0f, (Random)decoRand, 0.5f, COBWEB_SELECTOR, true);
        this.method_14917(world, class_2246.field_10260.method_9564(), (int)caveStartX, (int)caveStartY + 1, (int)caveStartZ, box);
        if (box.method_14662((class_2382)this.startPos)) {
            class_2586 spawnerTileEntity = world.method_8321(this.startPos.method_10093(class_2350.field_11036));
            if (spawnerTileEntity instanceof class_2636) {
                ((class_2636)spawnerTileEntity).method_11390().method_8274(class_1299.field_6084);
            } else {
                BetterDungeons.LOGGER.warn("Expected cave spider spawner entity at {}, but found none!", (Object)this.startPos.method_10093(class_2350.field_11036));
            }
        }
        this.decorateCave(world, (Random)decoRand, chunkPos, box, carvingMask);
        return true;
    }
}

