/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistryEntry;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.noise.OpenSimplexNoise;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.EntityRegistry;
import someoneelse.betternetherreforged.structures.IStructure;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.StructureWorld;
import someoneelse.betternetherreforged.structures.decorations.StructureStalactite;
import someoneelse.betternetherreforged.structures.decorations.StructureStalagmite;
import someoneelse.betternetherreforged.structures.plants.StructureWartCap;

public class NetherBiome
extends ForgeRegistryEntry<NetherBiome> {
    private static final OpenSimplexNoise SCATTER = new OpenSimplexNoise(1337L);
    private static int structureID = 0;
    private ArrayList<StructureInfo> generatorsFloor = new ArrayList();
    private ArrayList<StructureInfo> generatorsWall = new ArrayList();
    private ArrayList<StructureInfo> generatorsCeil = new ArrayList();
    private ArrayList<StructureInfo> generatorsLava = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsFloor = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsCeil = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsLava = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsUnder = new ArrayList();
    protected final ResourceLocation mcID;
    protected final Biome biome;
    protected float maxSubBiomeChance = 1.0f;
    protected float plantDensity = 1.0001f;
    protected float noiseDensity = 0.3f;
    protected float genChance = 1.0f;
    protected float edgeSize;
    protected List<Subbiome> subbiomes;
    protected NetherBiome biomeParent;
    protected NetherBiome edge;
    private static final String[] DEF_STRUCTURES = new String[]{NetherBiome.structureFormat("altar_01", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_02", -4, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_03", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_04", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_05", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_06", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_07", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_08", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("portal_01", -4, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("portal_02", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("garden_01", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("garden_02", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_01", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_02", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_03", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_04", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_05", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_06", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_01", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_02", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_03", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_04", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("spawn_altar_ladder", -5, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("ghast_hive", -20, StructureType.CEIL, 1.0f), NetherBiome.structureFormat("lava/pyramid_1", -1, StructureType.LAVA, 1.0f), NetherBiome.structureFormat("lava/pyramid_2", -1, StructureType.LAVA, 1.0f), NetherBiome.structureFormat("lava/pyramid_3", -1, StructureType.LAVA, 1.0f), NetherBiome.structureFormat("lava/pyramid_4", -1, StructureType.LAVA, 1.0f)};
    private ArrayList<String> structures;
    private Biome actualBiome;
    protected static final StructureStalagmite STALACTITE_NETHERRACK = new StructureStalagmite(BlocksRegistry.NETHERRACK_STALACTITE, null);
    protected static final StructureStalagmite STALACTITE_GLOWSTONE = new StructureStalagmite(BlocksRegistry.GLOWSTONE_STALACTITE, Blocks.field_150426_aN);
    protected static final StructureStalagmite STALACTITE_BLACKSTONE = new StructureStalagmite(BlocksRegistry.BLACKSTONE_STALACTITE, Blocks.field_235406_np_, Blocks.field_235406_np_, Blocks.field_150424_aL);
    protected static final StructureStalagmite STALACTITE_BASALT = new StructureStalagmite(BlocksRegistry.BASALT_STALACTITE, Blocks.field_235337_cO_, Blocks.field_235337_cO_, Blocks.field_150424_aL);
    protected static final StructureStalactite STALAGMITE_NETHERRACK = new StructureStalactite(BlocksRegistry.NETHERRACK_STALACTITE, null);
    protected static final StructureStalactite STALAGMITE_GLOWSTONE = new StructureStalactite(BlocksRegistry.GLOWSTONE_STALACTITE, Blocks.field_150426_aN);
    protected static final StructureStalactite STALAGMITE_BLACKSTONE = new StructureStalactite(BlocksRegistry.BLACKSTONE_STALACTITE, Blocks.field_235406_np_, Blocks.field_235406_np_, Blocks.field_150424_aL);
    protected static final StructureStalactite STALAGMITE_BASALT = new StructureStalactite(BlocksRegistry.BASALT_STALACTITE, Blocks.field_235337_cO_, Blocks.field_235337_cO_, Blocks.field_150424_aL);

    public NetherBiome(BiomeDefinition definition) {
        definition.addMobSpawn(EntityRegistry.FIREFLY, 5, 2, 6);
        definition.addMobSpawn(EntityRegistry.SKULL, 2, 2, 4);
        definition.addMobSpawn(EntityRegistry.NAGA, 20, 2, 4);
        definition.addMobSpawn(EntityRegistry.HYDROGEN_JELLYFISH, 5, 2, 5);
        this.biome = definition.build();
        this.mcID = definition.getID();
        this.subbiomes = new ArrayList<Subbiome>();
        this.addStructure("cap_gen", new StructureWartCap(), StructureType.WALL, 0.8f, true);
        this.subbiomes.add(new Subbiome(this, 1.0f));
        this.structures = new ArrayList(DEF_STRUCTURES.length);
        if (definition.hasBNStructures()) {
            for (String s : DEF_STRUCTURES) {
                this.structures.add(s);
            }
        }
        if (definition.hasStalactites()) {
            this.addStructure("netherrack_stalactite", STALACTITE_NETHERRACK, StructureType.FLOOR, 0.05f, true);
            this.addStructure("glowstone_stalactite", STALACTITE_GLOWSTONE, StructureType.FLOOR, 0.01f, true);
            this.addStructure("netherrack_stalagmite", STALAGMITE_NETHERRACK, StructureType.CEIL, 0.01f, true);
            this.addStructure("glowstone_stalagmite", STALAGMITE_GLOWSTONE, StructureType.CEIL, 0.005f, true);
        }
    }

    public void setPlantDensity(float density) {
        this.plantDensity = density * 1.0001f;
    }

    public float getPlantDensity() {
        return this.plantDensity;
    }

    public void setNoiseDensity(float density) {
        this.noiseDensity = 1.0f - density * 2.0f;
    }

    public float getNoiseDensity() {
        return (1.0f - this.noiseDensity) / 2.0f;
    }

    private String getGroup() {
        return "generator.biome." + this.mcID.func_110624_b() + "." + this.getRegistryName();
    }

    public void build() {
        String[] structAll;
        String group = this.getGroup();
        for (String struct : structAll = Configs.BIOMES.getStringArray(group, "schematics", this.structures.toArray(new String[0]))) {
            this.structureFromString(struct);
        }
        this.setNoiseDensity(Configs.BIOMES.getFloat(group, "noise_density", this.getNoiseDensity()));
    }

    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
    }

    public void genFloorObjects(IServerWorld world, BlockPos pos, Random random) {
        for (StructureInfo info : this.generatorsFloor) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    public void genWallObjects(IServerWorld world, BlockPos pos, Random random) {
        for (StructureInfo info : this.generatorsWall) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    public void genCeilObjects(IServerWorld world, BlockPos pos, Random random) {
        for (StructureInfo info : this.generatorsCeil) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    public void genLavaObjects(IServerWorld world, BlockPos pos, Random random) {
        for (StructureInfo info : this.generatorsLava) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    protected static double getFeatureNoise(BlockPos pos, int id) {
        return SCATTER.eval((double)pos.func_177958_n() * 0.1, (double)pos.func_177956_o() * 0.1 + (double)(id * 10), (double)pos.func_177952_p() * 0.1);
    }

    public String getRawBiomeRegistryName() {
        return this.mcID.func_110623_a();
    }

    public NetherBiome getEdge() {
        return this.edge;
    }

    public void setEdge(NetherBiome edge) {
        this.edge = edge;
        edge.biomeParent = this;
    }

    public float getEdgeSize() {
        return this.edgeSize;
    }

    public void setEdgeSize(float size) {
        this.edgeSize = size;
    }

    public void addSubBiome(NetherBiome biome, float chance) {
        this.maxSubBiomeChance += chance;
        biome.biomeParent = this;
        this.subbiomes.add(new Subbiome(biome, this.maxSubBiomeChance));
    }

    public NetherBiome getSubBiome(Random random) {
        float chance = random.nextFloat() * this.maxSubBiomeChance;
        for (Subbiome biome : this.subbiomes) {
            if (!biome.canGenerate(chance)) continue;
            return biome.biome;
        }
        return this;
    }

    public NetherBiome getParentBiome() {
        return this.biomeParent;
    }

    public boolean hasEdge() {
        return this.edge != null;
    }

    public boolean hasParentBiome() {
        return this.biomeParent != null;
    }

    public boolean isSame(NetherBiome biome) {
        return biome == this || biome.hasParentBiome() && biome.getParentBiome() == this;
    }

    protected void addStructure(String name, IStructure structure, StructureType type, float density, boolean useNoise) {
        String group = this.getGroup() + ".procedural." + type.getName() + "." + name;
        float dens = Configs.BIOMES.getFloat(group, "density", density);
        boolean limit = Configs.BIOMES.getBoolean(group, "limit", useNoise);
        this.addStructure(structure, type, dens, limit);
    }

    private void addStructure(IStructure structure, StructureType type, float density, boolean useNoise) {
        switch (type) {
            case CEIL: {
                this.generatorsCeil.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case FLOOR: {
                this.generatorsFloor.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case WALL: {
                this.generatorsWall.add(new StructureInfo(structure, density, useNoise));
                break;
            }
        }
    }

    protected void addWorldStructures(String ... structures) {
        for (String s : structures) {
            this.structures.add(s);
        }
    }

    public boolean canGenerate(float chance) {
        return chance <= this.genChance;
    }

    public void setGenChance(float chance) {
        this.genChance = chance;
    }

    protected static String structureFormat(String name, int offset, StructureType type, float chance) {
        return String.format(Locale.ROOT, "name: %s; offset: %d; type: %s; chance: %f", name, offset, type.getName(), Float.valueOf(chance));
    }

    public void genFloorBuildings(IServerWorld world, BlockPos pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsFloor);
    }

    public void genCeilBuildings(IServerWorld world, BlockPos pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsCeil);
    }

    public void genLavaBuildings(IServerWorld world, BlockPos pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsLava);
    }

    public void genUnderBuildings(IServerWorld world, BlockPos pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsUnder);
    }

    private void chancedStructure(IServerWorld world, BlockPos pos, Random random, List<StructureInfo> infoList) {
        float chance = this.getLastChance(infoList);
        if (chance > 0.0f) {
            float rnd = random.nextFloat() * chance;
            for (StructureInfo info : infoList) {
                if (!(rnd <= info.density)) continue;
                info.structure.generate(world, pos, random);
                return;
            }
        }
    }

    private void structureFromString(String structureString) {
        StructureWorld structure;
        String[] args = structureString.split(";");
        String name = "";
        int offset = 0;
        StructureType type = StructureType.FLOOR;
        float chance = 0.0f;
        for (String a : args) {
            if (a.contains("name:")) {
                name = a.replace("name:", "").trim();
                continue;
            }
            if (a.contains("offset:")) {
                offset = Integer.parseInt(a.replace("offset:", "").trim());
                continue;
            }
            if (a.contains("type:")) {
                type = StructureType.fromString(a);
                continue;
            }
            if (!a.contains("chance:")) continue;
            chance = Float.parseFloat(a.replace("chance:", "").trim());
        }
        if (!name.isEmpty() && (structure = new StructureWorld(name, offset, type)).loaded()) {
            ArrayList<StructureInfo> infoList = null;
            switch (structure.getType()) {
                case CEIL: {
                    infoList = this.buildGeneratorsCeil;
                    break;
                }
                case FLOOR: {
                    infoList = this.buildGeneratorsFloor;
                    break;
                }
                case LAVA: {
                    infoList = this.buildGeneratorsLava;
                    break;
                }
                case UNDER: {
                    infoList = this.buildGeneratorsUnder;
                    break;
                }
            }
            StructureInfo info = new StructureInfo(structure, chance += this.getLastChance(infoList), false);
            infoList.add(info);
        }
    }

    private float getLastChance(List<StructureInfo> info) {
        int size = info.size();
        return size > 0 ? info.get((int)(size - 1)).density : 0.0f;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public boolean hasCeilStructures() {
        return !this.buildGeneratorsCeil.isEmpty();
    }

    public String getNamespace() {
        return this.mcID.func_110624_b();
    }

    public String toString() {
        return this.mcID.toString();
    }

    public ResourceLocation getID() {
        return this.mcID;
    }

    public Biome getActualBiome() {
        return this.actualBiome;
    }

    public void setActualBiome(Biome actualBiome) {
        this.actualBiome = actualBiome;
    }

    protected class Subbiome {
        NetherBiome biome;
        float chance;

        Subbiome(NetherBiome biome, float chance) {
            this.biome = biome;
            this.chance = chance;
        }

        public boolean canGenerate(float chance) {
            return chance < this.chance;
        }
    }

    protected class StructureInfo {
        final IStructure structure;
        final float density;
        final boolean useNoise;
        final int id;

        StructureInfo(IStructure structure, float density, boolean useNoise) {
            this.structure = structure;
            this.density = density;
            this.useNoise = useNoise;
            this.id = structureID++;
        }

        boolean canGenerate(Random random, BlockPos pos) {
            return (!this.useNoise || NetherBiome.getFeatureNoise(pos, this.id) > (double)NetherBiome.this.noiseDensity) && random.nextFloat() < this.density;
        }
    }
}

