/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.plants.StructureBlackApple;
import someoneelse.betternetherreforged.structures.plants.StructureBlackBush;
import someoneelse.betternetherreforged.structures.plants.StructureInkBush;
import someoneelse.betternetherreforged.structures.plants.StructureMagmaFlower;
import someoneelse.betternetherreforged.structures.plants.StructureNetherGrass;
import someoneelse.betternetherreforged.structures.plants.StructureNetherWart;
import someoneelse.betternetherreforged.structures.plants.StructureReeds;
import someoneelse.betternetherreforged.structures.plants.StructureSmoker;
import someoneelse.betternetherreforged.structures.plants.StructureWallBrownMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWallMoss;
import someoneelse.betternetherreforged.structures.plants.StructureWallRedMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureWartSeed;

public class NetherGrasslands
extends NetherBiome {
    public NetherGrasslands(String name) {
        super(new BiomeDefinition(name).setFogColor(113, 73, 133).setLoop(SoundEvents.field_232711_f_).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_));
        this.addStructure("nether_reed", new StructureReeds(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("nether_wart", new StructureNetherWart(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("magma_flower", new StructureMagmaFlower(), StructureType.FLOOR, 0.5f, true);
        this.addStructure("smoker", new StructureSmoker(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("ink_bush", new StructureInkBush(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("black_apple", new StructureBlackApple(), StructureType.FLOOR, 0.01f, true);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.02f, true);
        this.addStructure("wart_seed", new StructureWartSeed(), StructureType.FLOOR, 0.02f, true);
        this.addStructure("nether_grass", new StructureNetherGrass(), StructureType.FLOOR, 0.4f, true);
        this.addStructure("wall_moss", new StructureWallMoss(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL, 0.8f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        switch (random.nextInt(3)) {
            case 0: {
                BlocksHelper.setWithoutUpdate(world, pos, Blocks.field_235336_cN_.func_176223_P());
                break;
            }
            case 1: {
                BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.NETHERRACK_MOSS.func_176223_P());
                break;
            }
            default: {
                super.genSurfColumn(world, pos, random);
            }
        }
        for (int i = 1; i < random.nextInt(3); ++i) {
            BlockPos down = pos.func_177979_c(i);
            if (random.nextInt(3) != 0 || !BlocksHelper.isNetherGround(world.func_180495_p(down))) continue;
            BlocksHelper.setWithoutUpdate(world, down, Blocks.field_150425_aM.func_176223_P());
        }
    }
}

