/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.decorations.StructureCrystal;
import someoneelse.betternetherreforged.structures.decorations.StructureGeyser;
import someoneelse.betternetherreforged.structures.plants.StructureGoldenVine;
import someoneelse.betternetherreforged.structures.plants.StructureMagmaFlower;

public class NetherMagmaLand
extends NetherBiome {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private static final boolean[] MASK = new boolean[]{false, true, false, false, false, false, false, true, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, true, false, false, false, false, true, true, false, false, true, true, true, false, false, false, true, true, false, false, false, true, false, false, true, true, true, false, false, true, true, true, true, false, true, true, true, true, false, false, false, true, true, false, false, true, true, true, false, false, false, false, false, true, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, true, true, true, true, true, false, false, false, true, true, true, true, false, false, false, true, true, false, true, true, true, true, true, true, true, false, false, true, true, false, true, true, false, false, false, true, false, false, true, false, false, false, false, false, true, true, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false, true, false, false, false, false, true, false, false, false, true, true, false, false, false, false, false, true, false, false, false, false, true, false, true, false, false, false, true, false, false, false, false, true, false, false, false, false, true, false, true, true, false, false, true, false, false, false, true, true, true, true, true, true, false, true, false, true, true, true, true, true, true, true, false, false, false, false, true, false, false, false, false, true, true, false, false, false, true, false, false, false, false, false, true, true, false, false};

    public NetherMagmaLand(String name) {
        super(new BiomeDefinition(name).setFogColor(248, 158, 68).setLoop(SoundEvents.field_232732_i_).setAdditions(SoundEvents.field_232723_h_).setMood(SoundEvents.field_232769_j_));
        this.addStructure("geyser", new StructureGeyser(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("obsidian_crystals", new StructureCrystal(), StructureType.FLOOR, 0.04f, true);
        this.addStructure("magma_flower", new StructureMagmaFlower(), StructureType.FLOOR, 0.4f, false);
        this.addStructure("golden_vine", new StructureGoldenVine(), StructureType.CEIL, 0.2f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        if (this.isMask(pos.func_177958_n(), pos.func_177952_p())) {
            POS.func_189533_g((Vector3i)pos);
            boolean magma = true;
            if (random.nextInt(4) == 0 && this.validWall(world, POS.func_177977_b()) && this.validWall(world, POS.func_177978_c()) && this.validWall(world, POS.func_177968_d()) && this.validWall(world, POS.func_177974_f()) && this.validWall(world, POS.func_177976_e())) {
                BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, Blocks.field_150353_l.func_176223_P());
                magma = false;
            }
            if (magma) {
                for (int y = 0; y < random.nextInt(3) + 1; ++y) {
                    POS.func_185336_p(pos.func_177956_o() - y);
                    if (!BlocksHelper.isNetherGround(world.func_180495_p((BlockPos)POS))) continue;
                    BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, Blocks.field_196814_hQ.func_176223_P());
                }
            }
        } else {
            super.genSurfColumn(world, pos, random);
        }
    }

    protected boolean validWall(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return BlocksHelper.isLava(state) || BlocksHelper.isNetherGroundMagma(state);
    }

    protected boolean isMask(int x, int z) {
        return MASK[(x &= 0xF) << 4 | (z &= 0xF)];
    }
}

