/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.entity.EntityChair;
import someoneelse.betternetherreforged.registry.EntityRegistry;

public class BNChair
extends BlockBaseNotFull {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private float height;

    public BNChair(Block block, int height) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.height = ((float)height - 3.0f) / 16.0f;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> StateContainer2) {
        StateContainer2.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.FAIL;
        }
        if (player.func_184218_aH() || player.func_175149_v()) {
            return ActionResultType.FAIL;
        }
        double px = (double)pos.func_177958_n() + 0.5;
        double py = (float)pos.func_177956_o() + this.height;
        double pz = (double)pos.func_177952_p() + 0.5;
        List active = world.func_175647_a(EntityChair.class, new AxisAlignedBB(pos), (Predicate)new Predicate<EntityChair>(){

            @Override
            public boolean test(EntityChair entity) {
                return entity.func_200601_bK();
            }
        });
        if (!active.isEmpty()) {
            return ActionResultType.FAIL;
        }
        float yaw = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d().func_185119_l();
        EntityChair entity = (EntityChair)EntityRegistry.CHAIR.func_200721_a(world);
        entity.func_70012_b(px, py, pz, yaw, 0.0f);
        entity.func_189654_d(true);
        entity.func_174810_b(true);
        entity.func_82142_c(true);
        entity.func_70034_d(yaw);
        entity.func_181013_g(yaw);
        if (world.func_217376_c((Entity)entity)) {
            player.func_184205_a((Entity)entity, true);
            player.func_181013_g(yaw);
            player.func_70034_d(yaw);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }
}

