/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;

public class BNLadder
extends BlockBaseNotFull {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape EAST_SHAPE = BNLadder.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = BNLadder.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = BNLadder.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_SHAPE = BNLadder.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public BNLadder(Block block) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)block).func_226896_b_());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING});
        stateManager.func_206894_a(new Property[]{WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    private boolean canPlaceOn(IBlockReader world, BlockPos pos, Direction side) {
        BlockState blockState = world.func_180495_p(pos);
        return !blockState.func_185897_m() && blockState.func_224755_d(world, pos, side);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return this.canPlaceOn((IBlockReader)world, pos.func_177972_a(direction.func_176734_d()), direction);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (facing.func_176734_d() == state.func_177229_b((Property)FACING) && !state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, neighborState, world, pos, neighborPos);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState2;
        if (!ctx.func_196012_c() && (blockState2 = ctx.func_195991_k().func_180495_p(ctx.func_195995_a().func_177972_a(ctx.func_196000_l().func_176734_d()))).func_177230_c() == this && blockState2.func_177229_b((Property)FACING) == ctx.func_196000_l()) {
            return null;
        }
        blockState2 = this.func_176223_P();
        World worldView = ctx.func_195991_k();
        BlockPos blockPos = ctx.func_195995_a();
        FluidState fluidState = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        for (Direction direction : ctx.func_196009_e()) {
            if (!direction.func_176740_k().func_176722_c() || !(blockState2 = (BlockState)blockState2.func_206870_a((Property)FACING, (Comparable)direction.func_176734_d())).func_196955_c((IWorldReader)worldView, blockPos)) continue;
            return (BlockState)blockState2.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

