/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import someoneelse.betternetherreforged.blocks.BlockCommonPlant;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.registry.EntityRegistry;

public class BlockEggPlant
extends BlockCommonPlant {
    private static final VoxelShape SHAPE = BlockEggPlant.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty DESTRUCTED = BooleanProperty.func_177716_a((String)"destructed");
    private boolean enableModDamage = Configs.MAIN.getBoolean("egg_plant", "mob_damage", true);
    private boolean enablePlayerDamage = Configs.MAIN.getBoolean("egg_plant", "player_damage", true);

    public BlockEggPlant() {
        super(MaterialColor.field_193561_M);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DESTRUCTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        super.func_206840_a(stateManager);
        stateManager.func_206894_a(new Property[]{DESTRUCTED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)DESTRUCTED)).booleanValue()) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + random.nextDouble(), 0.46, 0.28, 0.55);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!((Boolean)state.func_177229_b((Property)DESTRUCTED)).booleanValue()) {
            if (this.enableModDamage && entity instanceof LivingEntity && !((LivingEntity)entity).func_70644_a(Effects.field_76436_u)) {
                if (!EntityRegistry.isNetherEntity(entity)) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 3));
                }
            } else if (this.enablePlayerDamage && entity instanceof PlayerEntity && !((PlayerEntity)entity).func_70644_a(Effects.field_76436_u)) {
                ((PlayerEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 3));
            }
            double px = (double)pos.func_177958_n() + 0.5;
            double py = (double)pos.func_177956_o() + 0.125;
            double pz = (double)pos.func_177952_p() + 0.5;
            if (world.field_72995_K) {
                world.func_184134_a(px, py, pz, SoundType.field_235588_J_.func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                BlockParticleData effect = new BlockParticleData(ParticleTypes.field_197611_d, state);
                Random random = world.field_73012_v;
                for (int i = 0; i < 24; ++i) {
                    world.func_195594_a((IParticleData)effect, px + random.nextGaussian() * 0.2, py + random.nextGaussian() * 0.2, pz + random.nextGaussian() * 0.2, random.nextGaussian(), random.nextGaussian(), random.nextGaussian());
                }
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DESTRUCTED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (((ItemStack)builder.func_216019_b(LootParameters.field_216289_i)).func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
            return Collections.singletonList(new ItemStack((IItemProvider)this.func_199767_j()));
        }
        return super.func_220076_a(state, builder);
    }

    @Override
    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)DESTRUCTED)).booleanValue()) {
            world.func_175656_a(pos, this.func_176223_P());
        }
    }
}

