/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.ItemsRegistry;

public class BlockJellyfishMushroom
extends BlockBaseNotFull {
    private static final VoxelShape TOP_SHAPE = BlockJellyfishMushroom.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockJellyfishMushroom.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<TripleShape> SHAPE = EnumProperty.func_177709_a((String)"shape", TripleShape.class);
    public static final EnumProperty<JellyShape> VISUAL = EnumProperty.func_177709_a((String)"visual", JellyShape.class);

    public BlockJellyfishMushroom() {
        super(MaterialBuilder.makeWood(MaterialColor.field_151679_y).func_200943_b(0.1f).func_200947_a(SoundType.field_235580_B_).func_226896_b_().func_235838_a_(state -> 13));
        this.setRenderLayer(BNRenderLayer.TRANSLUCENT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE, VISUAL});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return state.func_177229_b(SHAPE) == TripleShape.TOP ? TOP_SHAPE : MIDDLE_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)BlocksRegistry.JELLYFISH_MUSHROOM_SAPLING);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader view, BlockPos pos) {
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        switch ((TripleShape)((Object)state.func_177229_b(SHAPE))) {
            case BOTTOM: {
                return world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP) ? state : Blocks.field_150350_a.func_176223_P();
            }
            case MIDDLE: {
                return world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP) ? state : Blocks.field_150350_a.func_176223_P();
            }
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this ? state : Blocks.field_150350_a.func_176223_P();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if (world.func_180495_p(pos).func_177229_b(SHAPE) != TripleShape.TOP) {
            return;
        }
        if (entity.func_226272_bl_()) {
            super.func_180658_a(world, pos, entity, distance);
        } else {
            entity.func_225503_b_(distance, 0.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_176216_a(IBlockReader world, Entity entity) {
        if (entity.func_226272_bl_()) {
            super.func_176216_a(world, entity);
        } else {
            this.bounce(entity);
        }
    }

    private void bounce(Entity entity) {
        Vector3d Vector3d2 = entity.func_213322_ci();
        if (Vector3d2.field_72448_b < 0.0) {
            entity.func_70016_h(Vector3d2.field_72450_a, -Vector3d2.field_72448_b, Vector3d2.field_72449_c);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (world.func_180495_p(pos).func_177229_b(SHAPE) != TripleShape.TOP) {
            super.func_176199_a(world, pos, entity);
            return;
        }
        double d = Math.abs(entity.func_213322_ci().field_72448_b);
        if (d < 0.1 && !entity.func_226272_bl_()) {
            double e = 0.4 + d * 0.2;
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(e, 1.0, e));
        }
        super.func_176199_a(world, pos, entity);
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (state.func_177229_b(SHAPE) == TripleShape.TOP) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.JELLYFISH_MUSHROOM_SAPLING, MHelper.randRange(1, 2, MHelper.RANDOM)), new ItemStack((IItemProvider)ItemsRegistry.GLOWSTONE_PILE, MHelper.randRange(0, 2, MHelper.RANDOM)), new ItemStack((IItemProvider)Items.field_151123_aH, MHelper.randRange(0, 1, MHelper.RANDOM))});
        }
        if (state.func_177229_b(SHAPE) == TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.JELLYFISH_MUSHROOM_SAPLING, MHelper.randRange(1, 2, MHelper.RANDOM))});
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM)});
    }

    public static enum JellyShape implements IStringSerializable
    {
        NORMAL("normal"),
        SEPIA("sepia"),
        POOR("poor");

        final String name;

        private JellyShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

