/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.registry.ItemsRegistry;

public class BlockLucisMushroom
extends BlockBaseNotFull {
    private static final VoxelShape V_SHAPE = BlockLucisMushroom.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<EnumShape> SHAPE = EnumProperty.func_177709_a((String)"shape", EnumShape.class);

    public BlockLucisMushroom() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151673_t).harvestTool(ToolType.AXE).func_200947_a(SoundType.field_185848_a).func_200943_b(1.0f).func_235838_a_(state -> 15).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)((Object)EnumShape.CORNER)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING, SHAPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return V_SHAPE;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)BlocksRegistry.LUCIS_SPORE), new ItemStack((IItemProvider)ItemsRegistry.GLOWSTONE_PILE, MHelper.randRange(2, 4, MHelper.RANDOM))});
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (mirror == Mirror.FRONT_BACK) {
            if (state.func_177229_b(SHAPE) == EnumShape.SIDE) {
                state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176735_f());
            }
            if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.WEST);
            }
            if (state.func_177229_b((Property)FACING) == Direction.WEST) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.EAST);
            }
            if (state.func_177229_b((Property)FACING) == Direction.EAST) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.SOUTH);
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (state.func_177229_b(SHAPE) == EnumShape.SIDE) {
                state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176735_f());
            }
            if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.EAST);
            }
            if (state.func_177229_b((Property)FACING) == Direction.EAST) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
            }
            if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.WEST);
            }
            if (state.func_177229_b((Property)FACING) == Direction.WEST) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.SOUTH);
            }
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)BlocksRegistry.LUCIS_SPORE);
    }

    public static enum EnumShape implements IStringSerializable
    {
        CORNER("corner"),
        SIDE("side"),
        CENTER("center");

        final String name;

        private EnumShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

