/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.shapes.TripleShape;
import someoneelse.betternetherreforged.registry.ItemsRegistry;

public class BlockLumabusVine
extends BlockBaseNotFull {
    private static final VoxelShape MIDDLE_SHAPE = BlockLumabusVine.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape BOTTOM_SHAPE = BlockLumabusVine.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final EnumProperty<TripleShape> SHAPE = EnumProperty.func_177709_a((String)"shape", TripleShape.class);
    private static final Random RANDOM = new Random();
    private final Block seed;

    public BlockLumabusVine(Block seed) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151679_y).func_200947_a(SoundType.field_222472_s).func_200942_a().func_200946_b().func_226896_b_().func_235838_a_(BlockLumabusVine.getLuminance()));
        this.seed = seed;
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(SHAPE, (Comparable)((Object)TripleShape.TOP)));
    }

    private static ToIntFunction<BlockState> getLuminance() {
        return blockState -> blockState.func_177229_b(SHAPE) == TripleShape.BOTTOM ? 15 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return state.func_177229_b(SHAPE) == TripleShape.BOTTOM ? BOTTOM_SHAPE : MIDDLE_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        return upState.func_177230_c() == this || upState.func_224755_d((IBlockReader)world, pos, Direction.DOWN);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader view, BlockPos pos) {
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        return this.func_196260_a(state, (IWorldReader)world, pos) && (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this || state.func_177229_b(SHAPE) == TripleShape.BOTTOM) ? state : Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (state.func_177229_b(SHAPE) == TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)this.seed, MHelper.randRange(1, 3, RANDOM)), new ItemStack((IItemProvider)ItemsRegistry.GLOWSTONE_PILE, MHelper.randRange(1, 3, RANDOM))});
        }
        return Lists.newArrayList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.seed);
    }
}

