/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBNPot;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlockPottedPlant
extends BlockBaseNotFull {
    public static final EnumProperty<PottedPlantShape> PLANT = EnumProperty.func_177709_a((String)"plant", PottedPlantShape.class);

    public BlockPottedPlant() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151646_E).func_200947_a(SoundType.field_222472_s).func_226896_b_().func_200942_a().func_200946_b().func_235838_a_(BlockPottedPlant.getLuminance()));
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(PLANT, (Comparable)((Object)PottedPlantShape.AGAVE)));
    }

    private static ToIntFunction<BlockState> getLuminance() {
        return blockState -> {
            if (blockState.func_177229_b(PLANT) == PottedPlantShape.WILLOW) {
                return 12;
            }
            if (blockState.func_177229_b(PLANT) == PottedPlantShape.JELLYFISH_MUSHROOM) {
                return 13;
            }
            return 0;
        };
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        Block block = ((PottedPlantShape)((Object)state.func_177229_b(PLANT))).getBlock();
        Vector3d vec3d = block.func_176223_P().func_191059_e(view, pos);
        return block.func_220053_a(block.func_176223_P(), view, pos, ePos).func_197751_a(-vec3d.field_72450_a, -0.5 - vec3d.field_72448_b, -vec3d.field_72449_c);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{PLANT});
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockBNPot;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        Block block = ((PottedPlantShape)((Object)state.func_177229_b(PLANT))).getBlock();
        return Collections.singletonList(new ItemStack((IItemProvider)block.func_199767_j()));
    }

    public static BlockState getPlant(Item item) {
        for (PottedPlantShape shape : PottedPlantShape.values()) {
            if (!shape.getItem().equals(item)) continue;
            return (BlockState)BlocksRegistry.POTTED_PLANT.func_176223_P().func_206870_a(PLANT, (Comparable)((Object)shape));
        }
        return null;
    }

    public static enum PottedPlantShape implements IStringSerializable
    {
        AGAVE("agave", BlocksRegistry.AGAVE),
        BARREL_CACTUS("barrel_cactus", BlocksRegistry.BARREL_CACTUS),
        BLACK_APPLE("black_apple", BlocksRegistry.BLACK_APPLE_SEED),
        BLACK_BUSH("black_bush", BlocksRegistry.BLACK_BUSH),
        EGG_PLANT("egg_plant", BlocksRegistry.EGG_PLANT),
        INK_BUSH("ink_bush", BlocksRegistry.INK_BUSH_SEED),
        REEDS("reeds", BlocksRegistry.NETHER_REED),
        NETHER_CACTUS("nether_cactus", BlocksRegistry.NETHER_CACTUS),
        NETHER_GRASS("nether_grass", BlocksRegistry.NETHER_GRASS),
        ORANGE_MUSHROOM("orange_mushroom", BlocksRegistry.ORANGE_MUSHROOM),
        RED_MOLD("red_mold", BlocksRegistry.RED_MOLD),
        GRAY_MOLD("gray_mold", BlocksRegistry.GRAY_MOLD),
        MAGMA_FLOWER("magma_flower", BlocksRegistry.MAGMA_FLOWER),
        NETHER_WART("nether_wart", BlocksRegistry.WART_SEED),
        WILLOW("willow", BlocksRegistry.WILLOW_SAPLING),
        SMOKER("smoker", BlocksRegistry.SMOKER),
        WART("wart", Blocks.field_150388_bm),
        JUNGLE_PLANT("jungle_plant", BlocksRegistry.JUNGLE_PLANT),
        JELLYFISH_MUSHROOM("jellyfish_mushroom", BlocksRegistry.JELLYFISH_MUSHROOM_SAPLING),
        SWAMP_GRASS("swamp_grass", BlocksRegistry.SWAMP_GRASS),
        SOUL_GRASS("soul_grass", BlocksRegistry.SOUL_GRASS),
        BONE_GRASS("bone_grass", BlocksRegistry.BONE_GRASS),
        BONE_MUSHROOM("bone_mushroom", BlocksRegistry.BONE_MUSHROOM);

        private final Block block;
        private final String name;

        private PottedPlantShape(String name, Block block) {
            this.name = name;
            this.block = block;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Item getItem() {
            return this.block.func_199767_j();
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

