/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBase;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlockRubeusLeaves
extends BlockBase {
    private static final int MAX_DIST = 10;
    public static final IntegerProperty DISTANCE_CUSTOM = IntegerProperty.func_177719_a((String)"dist_custom", (int)1, (int)10);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;

    public BlockRubeusLeaves() {
        super(MaterialBuilder.makeLeaves(MaterialColor.field_151674_s));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DISTANCE_CUSTOM, (Comparable)Integer.valueOf(1))).func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PERSISTENT, DISTANCE_CUSTOM});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return BlockRubeusLeaves.updateDistanceFromLogs((BlockState)this.func_176223_P().func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (IWorld)ctx.func_195991_k(), ctx.func_195995_a());
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)DISTANCE_CUSTOM) == 10 && (Boolean)state.func_177229_b((Property)PERSISTENT) == false;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((Property)PERSISTENT)).booleanValue() && (Integer)state.func_177229_b((Property)DISTANCE_CUSTOM) == 10) {
            BlockRubeusLeaves.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        world.func_180501_a(pos, BlockRubeusLeaves.updateDistanceFromLogs(state, (IWorld)world, pos), 3);
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        int dist = BlockRubeusLeaves.getDistanceFromLog(newState) + 1;
        if (dist != 1 || (Integer)state.func_177229_b((Property)DISTANCE_CUSTOM) != dist) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
        return state;
    }

    private static BlockState updateDistanceFromLogs(BlockState state, IWorld world, BlockPos pos) {
        int dist = 10;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction dir : Direction.values()) {
            mutable.func_239622_a_((Vector3i)pos, dir);
            dist = Math.min(dist, BlockRubeusLeaves.getDistanceFromLog(world.func_180495_p((BlockPos)mutable)) + 1);
            if (dist == 1) break;
        }
        return (BlockState)state.func_206870_a((Property)DISTANCE_CUSTOM, (Comparable)Integer.valueOf(dist));
    }

    private static int getDistanceFromLog(BlockState state) {
        if (state.func_177230_c() == BlocksRegistry.RUBEUS_LOG || state.func_177230_c() == BlocksRegistry.RUBEUS_BARK) {
            return 0;
        }
        return state.func_177230_c() instanceof BlockRubeusLeaves ? (Integer)state.func_177229_b((Property)DISTANCE_CUSTOM) : 10;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void randomDisplayTick(BlockState state, World world, BlockPos pos, Random random) {
        BlockPos blockPos;
        BlockState blockState;
        if (!(!world.func_175727_C(pos.func_177984_a()) || random.nextInt(15) != 1 || (blockState = world.func_180495_p(blockPos = pos.func_177977_b())).func_200132_m() && blockState.func_224755_d((IBlockReader)world, blockPos, Direction.UP))) {
            double d = (float)pos.func_177958_n() + random.nextFloat();
            double e = (double)pos.func_177956_o() - 0.05;
            double f = (float)pos.func_177952_p() + random.nextFloat();
            world.func_195594_a((IParticleData)ParticleTypes.field_197618_k, d, e, f, 0.0, 0.0, 0.0);
        }
    }
}

