/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.config.Configs;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlockStatueRespawner
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE = BlockStatueRespawner.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final RedstoneParticleData EFFECT = new RedstoneParticleData(1.0f, 0.0f, 0.0f, 1.0f);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");
    private final ItemStack requiredItem;

    public BlockStatueRespawner() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)BlocksRegistry.CINCINNASITE_BLOCK).func_226896_b_().func_235838_a_(state -> 15));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false)));
        this.setDropItself(false);
        String itemName = Configs.MAIN.getString("respawn_statue", "respawn_item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)Items.field_221695_cJ).toString());
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == Items.field_190931_a) {
            item = Items.field_221695_cJ;
        }
        int count = Configs.MAIN.getInt("respawn_statue", "item_count", 4);
        this.requiredItem = new ItemStack((IItemProvider)item, count);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING, TOP});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == this.requiredItem.func_77973_b() && stack.func_190916_E() >= this.requiredItem.func_190916_E()) {
            float y;
            float f = y = (Boolean)state.func_177229_b((Property)TOP) != false ? 0.4f : 1.4f;
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190918_g(this.requiredItem.func_190916_E());
            }
            for (int i = 0; i < 50; ++i) {
                world.func_195594_a((IParticleData)EFFECT, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177956_o() + y) + (double)world.field_73012_v.nextFloat() * 0.2, (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), 0.0, 0.0, 0.0);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.spawn_set", new Object[0]), true);
            if (!world.field_72995_K) {
                ((ServerPlayerEntity)player).func_242111_a(world.func_234923_W_(), pos, player.func_70079_am(), false, true);
            }
            player.func_184185_a(SoundEvents.field_191263_gW, 0.7f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("message.spawn_help", new Object[]{this.requiredItem}), true);
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
            return true;
        }
        BlockState up = world.func_180495_p(pos.func_177984_a());
        return up.func_196958_f() || up.func_177230_c() == this && (Boolean)up.func_177229_b((Property)TOP) != false;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.func_201670_d()) {
            BlocksHelper.setWithUpdate((IWorld)((ServerWorld)world), pos.func_177984_a(), (BlockState)state.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)TOP)).booleanValue()) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this ? state : Blocks.field_150350_a.func_176223_P();
        }
        return world.func_180495_p(pos.func_177984_a()).func_177230_c() == this ? state : Blocks.field_150350_a.func_176223_P();
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (player.func_184812_l_() && ((Boolean)state.func_177229_b((Property)TOP)).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
        }
        super.func_176208_a(world, pos, state, player);
    }
}

