/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.structures.plants.StructureWartTree;

public class BlockWartSeed
extends BlockBaseNotFull
implements IGrowable {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);
    private static final StructureWartTree STRUCTURE = new StructureWartTree();
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public BlockWartSeed() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193559_aa).func_200947_a(SoundType.field_235588_J_).func_200943_b(1.0f).func_226896_b_().func_200942_a());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return BOUNDING_SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = this.func_176223_P();
        World worldView = ctx.func_195991_k();
        BlockPos blockPos = ctx.func_195995_a();
        Direction[] directions = ctx.func_196009_e();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction = directions[i];
            Direction direction2 = direction.func_176734_d();
            if (!(blockState = (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)direction2)).func_196955_c((IWorldReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        return BlockWartSeed.func_220055_a((IWorldReader)world, (BlockPos)blockPos, (Direction)direction) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150425_aM;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return direction == Direction.UP && BlocksHelper.isSoulSand(world.func_180495_p(pos.func_177977_b()));
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return random.nextInt(8) == 0;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        STRUCTURE.grow((IServerWorld)world, pos, random);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75));
        BOUNDING_SHAPES.put(Direction.DOWN, VoxelShapes.func_197873_a((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75));
        BOUNDING_SHAPES.put(Direction.NORTH, VoxelShapes.func_197873_a((double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, VoxelShapes.func_197873_a((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, VoxelShapes.func_197873_a((double)0.5, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75));
        BOUNDING_SHAPES.put(Direction.EAST, VoxelShapes.func_197873_a((double)0.0, (double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75));
    }
}

