/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.datagen;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BNRecipes
extends RecipeProvider {
    public static final ArrayList<SingleInputRecipe> STAIRS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> SLABS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> ROOFS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> PLATES = new ArrayList();
    public static final ArrayList<SingleInputRecipe> TWOBYTWO = new ArrayList();
    public static final ArrayList<SingleInputRecipe> FENCES = new ArrayList();
    public static final ArrayList<SingleInputRecipe> GATES = new ArrayList();
    public static final ArrayList<SingleInputRecipe> DOORS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> TRAPDOORS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> WALLS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> ROUND = new ArrayList();
    public static final ArrayList<SingleInputRecipe> SIGNS = new ArrayList();
    public static final ArrayList<TwoInputRecipe> BARRELS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> LADDERS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> TABURETS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> CHAIRS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> BAR_STOOLS = new ArrayList();
    public static final ArrayList<FireBowlRecipe> FIRE_BOWLS = new ArrayList();
    public static final ArrayList<SingleInputRecipe> SHAPELESS = new ArrayList();

    public BNRecipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        for (SingleInputRecipe singleInputRecipe : STAIRS) {
            BNRecipes.makeStairsRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : SLABS) {
            BNRecipes.makeSlabRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : ROOFS) {
            BNRecipes.makeRoofRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : PLATES) {
            BNRecipes.makePlateRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : TWOBYTWO) {
            BNRecipes.make2x2Recipe(singleInputRecipe.input, singleInputRecipe.output, singleInputRecipe.quantityOut, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : FENCES) {
            BNRecipes.makeFenceRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : GATES) {
            BNRecipes.makeGateRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : DOORS) {
            BNRecipes.makeDoorRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : TRAPDOORS) {
            BNRecipes.makeTrapdoorRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : WALLS) {
            BNRecipes.makeWallRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : ROUND) {
            BNRecipes.makeRoundRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : SIGNS) {
            BNRecipes.makeSignRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (TwoInputRecipe twoInputRecipe : BARRELS) {
            BNRecipes.makeBarrelRecipe(twoInputRecipe.input1, twoInputRecipe.input2, twoInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : LADDERS) {
            BNRecipes.makeLadderRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : TABURETS) {
            BNRecipes.makeTaburetRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : CHAIRS) {
            BNRecipes.makeChairRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : BAR_STOOLS) {
            BNRecipes.makeBarStoolRecipe(singleInputRecipe.input, singleInputRecipe.output, consumer);
        }
        for (FireBowlRecipe fireBowlRecipe : FIRE_BOWLS) {
            BNRecipes.makeFireBowlRecipe(fireBowlRecipe.source, fireBowlRecipe.inside, fireBowlRecipe.legs, fireBowlRecipe.output, consumer);
        }
        for (SingleInputRecipe singleInputRecipe : SHAPELESS) {
            BNRecipes.makeShapelessSingleInputRecipe(singleInputRecipe.input, singleInputRecipe.output, singleInputRecipe.quantityOut, consumer);
        }
    }

    public static void makeStairsRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)4).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeSlabRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)6).func_200472_a("###").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeRoofRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)6).func_200472_a("# #").func_200472_a("###").func_200472_a(" # ").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makePlateRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("##").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void make2x2Recipe(ResourceLocation input, ResourceLocation output, int outputQuantity, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)outputQuantity).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeFenceRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)3).func_200472_a("#I#").func_200472_a("#I#").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeGateRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("I#I").func_200472_a("I#I").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeDoorRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)3).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeTrapdoorRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)2).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeWallRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)6).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeRoundRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200462_a(Character.valueOf('#'), ingredient).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeSignRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("###").func_200472_a("###").func_200472_a(" I ").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeBarrelRecipe(ResourceLocation input1, ResourceLocation input2, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider block = BNRecipes.getRegisteredItem(input1);
        IItemProvider slab = BNRecipes.getRegisteredItem(input2);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("#S#").func_200472_a("# #").func_200472_a("#S#").func_200462_a(Character.valueOf('#'), block).func_200462_a(Character.valueOf('S'), slab).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(block), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)block)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(block));
    }

    public static void makeLadderRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("I I").func_200472_a("I#I").func_200472_a("I I").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeTaburetRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("##").func_200472_a("II").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeChairRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("I ").func_200472_a("##").func_200472_a("II").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeBarStoolRecipe(ResourceLocation input, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("##").func_200472_a("II").func_200472_a("II").func_200462_a(Character.valueOf('#'), ingredient).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    public static void makeFireBowlRecipe(ResourceLocation input1, ResourceLocation input2, ResourceLocation input3, ResourceLocation output, Consumer<IFinishedRecipe> consumer) {
        IItemProvider block = BNRecipes.getRegisteredItem(input1);
        IItemProvider leg = BNRecipes.getRegisteredItem(input2);
        IItemProvider inside = BNRecipes.getRegisteredItem(input3);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("#I#").func_200472_a(" # ").func_200472_a("L L").func_200462_a(Character.valueOf('#'), block).func_200462_a(Character.valueOf('I'), inside).func_200462_a(Character.valueOf('L'), leg).func_200473_b("betternether").func_200465_a(BNRecipes.getPath(block), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)block)).func_200466_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(block));
    }

    public static void makeShapelessSingleInputRecipe(ResourceLocation input, ResourceLocation output, int outputQuantity, Consumer<IFinishedRecipe> consumer) {
        IItemProvider ingredient = BNRecipes.getRegisteredItem(input);
        IItemProvider result = BNRecipes.getRegisteredItem(output);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)outputQuantity).func_200487_b(ingredient).func_200490_a("betternether").func_200483_a(BNRecipes.getPath(ingredient), (ICriterionInstance)BNRecipes.func_200403_a((IItemProvider)ingredient)).func_200484_a(consumer, BNRecipes.getPath(result) + "_from_" + BNRecipes.getPath(ingredient));
    }

    private static String getPath(IItemProvider item) {
        return item.func_199767_j().getRegistryName().func_110623_a();
    }

    private static IItemProvider getRegisteredItem(ResourceLocation loc) {
        return (IItemProvider)ForgeRegistries.ITEMS.getValue(loc);
    }

    public static class FireBowlRecipe {
        public final ResourceLocation source;
        public final ResourceLocation inside;
        public final ResourceLocation legs;
        public final ResourceLocation output;

        public FireBowlRecipe(Block input1, Block input2, Item input3, Block output) {
            this.source = input1.getRegistryName();
            this.inside = input2.getRegistryName();
            this.legs = input3.getRegistryName();
            this.output = output.getRegistryName();
        }
    }

    public static class TwoInputRecipe {
        public final ResourceLocation input1;
        public final ResourceLocation input2;
        public final ResourceLocation output;

        public TwoInputRecipe(Block input1, Block input2, Block output) {
            this.input1 = input1.getRegistryName();
            this.input2 = input2.getRegistryName();
            this.output = output.getRegistryName();
        }
    }

    public static class SingleInputRecipe {
        public final ResourceLocation input;
        public final ResourceLocation output;
        public int quantityOut = 1;

        public SingleInputRecipe(Block input, Block output) {
            this.input = input.getRegistryName();
            this.output = output.getRegistryName();
        }

        public SingleInputRecipe(Block input, Block output, int quantityOut) {
            this.input = input.getRegistryName();
            this.output = output.getRegistryName();
            this.quantityOut = quantityOut;
        }
    }
}

